/*
 * MultipleKeyMap.java
 * Created on 2003/10/16
 * 
 * Copyright (c) 2003 CreW Project. All rights reserved.
 */
package jp.ac.keio.sfc.crew.collection;

import java.util.List;

/**
 * Class MultipleKeyMap.
 * 
 * @author macchan
 * @version $Id: MultipleKeyMap.java,v 1.1 2003/12/11 10:26:52 macchan Exp $
 */
public class MultipleKeyMap {

	private MultipleValueMap map = new MultipleValueMap();

	/**
	 * Constructor for MultipleDoubleKeyMap.
	 */
	public MultipleKeyMap() {
	}

	public void put(Object key1, Object key2, Object value) {
		map.put(new DoubleKey(key1, key2), value);
	}

	public List get(Object key1, Object key2) {
		return map.get(new DoubleKey(key1, key2));
	}

	public void removeByValue(Object value) {
		map.removeByValue(value);
	}

	public List removeByKey(Object key1, Object key2) {
		return map.removeByKey(new DoubleKey(key1, key2));
	}

	public boolean containtsKey(Object key1, Object key2) {
		return map.containtsKey(new DoubleKey(key1, key2));
	}

	public boolean containtsValue(Object value) {
		return map.containtsValue(value);
	}

	public List getValues() {
		return map.getValues();
	}

	class DoubleKey {
		private Object key1;
		private Object key2;
		DoubleKey(Object key1, Object key2) {
			this.key1 = key1;
			this.key2 = key2;
		}
		public int hashCode() {
			return key1.hashCode() + key2.hashCode();
		}
		public boolean equals(Object o) {
			DoubleKey t = (DoubleKey) o;
			return (
				(key1 == t.key1 || key1 == t.key2)
					&& (key2 == t.key1 || key2 == t.key2)
					&& (key1 != key2));
		}
	}
}
