/*
 * MultipleValueMap.java
 * Created on 2003/10/10
 * 
 * Copyright (c) 2003 CreW Project. All rights reserved.
 */
package jp.ac.keio.sfc.crew.collection;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/**
 * Class MultipleValueMap.
 * 
 * @author macchan
 * @version $Id: MultipleValueMap.java,v 1.1 2003/12/11 10:26:52 macchan Exp $
 */
public class MultipleValueMap implements Serializable {

	private Map tableByKey = new HashMap();
	private Map tableByValue = new HashMap();
	private List values = new ArrayList();

	/**
	 * Constructor for MultipleValueMap.
	 */
	public MultipleValueMap() {
		super();
	}

	/**
	 * Puts the element.
	 * @param key
	 * @param value
	 */
	public void put(Object key, Object value) {
		//Argument checks.
		if (containtsValue(value)) {
			throw new IllegalArgumentException(
				"The element " + value + " has already put");
		}

		//Puts to values List.
		values.add(value);

		//Puts to tableByValue
		tableByValue.put(value, key);

		//Puts to tableByKey
		if (tableByKey.get(key) == null) {
			tableByKey.put(key, new ArrayList());
		}
		List values = (List) tableByKey.get(key);
		values.add(value);
	}

	/**
	 * Gets the element(s).
	 * @param key
	 * @return
	 */
	public List get(Object key) {
		//Gets the element(s)
		List values = (List) tableByKey.get(key);

		//Returns suitable List.
		if (values != null) {
			return new ArrayList(values);
		} else {
			return Collections.EMPTY_LIST;
		}
	}

	/**
	 * Removes the element by value.
	 * @param value
	 */
	public void removeByValue(Object value) {
		//Argument checks.		
		if (!containtsValue(value)) {
			throw new IllegalArgumentException(
				"The element " + value + " has not put");
		}

		//Removes from values List.
		values.remove(value);

		//Removes from tableByKey
		Object key = tableByValue.get(value);
		List values = (List) tableByKey.get(key);
		values.remove(value);
		if (values.isEmpty()) {
			tableByKey.remove(key);
		}

		//Removes from tableByValue
		tableByValue.remove(value);
	}

	/**
	 * Removes the element(s) by key.
	 * @param key
	 * @return
	 */
	public List removeByKey(Object key) {
		//Argument checks.
		if (!containtsKey(key)) {
			throw new IllegalArgumentException(
				"The key " + key + " has not put");
		}

		//Removes from values List, and tableByValue.
		List values = (List) tableByKey.get(key);
		for (Iterator i = values.iterator(); i.hasNext();) {
			Object removeValue = (Object) i.next();

			//Removes from values List.
			this.values.remove(removeValue);

			//Removes from tableByValue.
			tableByValue.remove(removeValue);
		}

		//Removes from tableByKey
		tableByKey.remove(key);

		return values;
	}

	/**
	 * Checks if containts the key. 
	 * @param key
	 * @return
	 */
	public boolean containtsKey(Object key) {
		return tableByKey.containsKey(key);
	}

	/**
	 * Checks if containts the value.
	 * @param value
	 * @return
	 */
	public boolean containtsValue(Object value) {
		return tableByValue.containsKey(value);
	}

	/**
	 * Gets the all value.
	 * @return
	 */
	public List getValues() {
		return new ArrayList(values);
	}

}
