/*
 * LayerLayoutManager.java
 * Created on 2003/10/12
 * 
 * Copyright (c) 2003 CreW Project. All rights reserved.
 */
package jp.ac.keio.sfc.crew.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;

import jp.ac.keio.sfc.crew.swing.visuals.*;

/**
 * Class LayerLayoutManager.
 * 
 * @author macchan
 * @version $Id: LayerLayoutManager.java,v 1.1 2003/12/11 10:27:04 macchan Exp $
 */
public class LayerLayoutManager implements LayoutManager {

	/**
	 * Constructor for LayerLayoutManager.
	 */
	public LayerLayoutManager() {
		super();
	}

	/* (non-Javadoc)
	 * @see java.awt.LayoutManager#addLayoutComponent(java.lang.String, java.awt.Component)
	 */
	public void addLayoutComponent(String name, Component comp) {
	}

	/* (non-Javadoc)
	 * @see java.awt.LayoutManager#removeLayoutComponent(java.awt.Component)
	 */
	public void removeLayoutComponent(Component comp) {
	}

	/* (non-Javadoc)
	 * @see java.awt.LayoutManager#preferredLayoutSize(java.awt.Container)
	 */
	public Dimension preferredLayoutSize(Container parent) {
		return parent.getSize();
	}

	/* (non-Javadoc)
	 * @see java.awt.LayoutManager#minimumLayoutSize(java.awt.Container)
	 */
	public Dimension minimumLayoutSize(Container parent) {
		return preferredLayoutSize(parent);
	}

	/* (non-Javadoc)
	 * @see java.awt.LayoutManager#layoutContainer(java.awt.Container)
	 */
	public void layoutContainer(Container parent) {
		synchronized (parent.getTreeLock()) {
			Component[] components = parent.getComponents();
			for (int i = 0; i < components.length; i++) {
				if (components[i] instanceof LayerVisualComponent) {
					components[i].setLocation(0, 0);
					components[i].setSize(parent.getSize());
				}
			}
		}
	}

}
