/*
 * SwingUtil.java
 * Created on 2003/10/12
 * 
 * Copyright (c) 2003 CreW Project. All rights reserved.
 */
package jp.ac.keio.sfc.crew.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;

import jp.ac.keio.sfc.crew.swing.visuals.*;

/**
 * Class SwingUtil.
 * 
 * @author macchan
 * @version $Id: SwingUtil.java,v 1.1 2003/12/11 10:27:04 macchan Exp $
 */
public class SwingUtil {

	/*****************************
	 * Constants.
	 *****************************/

	public static final Color COLOR_OPAQUE = createAlphaedColor(Color.WHITE, 0);

	/*****************************
	 * Constructors.
	 *****************************/

	/**
	 * Constructor for SwingUtil.
	 */
	private SwingUtil() {
		super();
	}

	/*****************************
	 * Utility Methods.
	 *****************************/

	public static final Color createAlphaedColor(Color c, int alpha) {
		return new Color(c.getRed(), c.getGreen(), c.getBlue(), alpha);
	}

	public static Component getDeepestComponentAt(
		Component parent,
		int x,
		int y) {

		if (!parent.contains(x, y)) {
			return null;
		}

		if (parent instanceof Container) {
			Component components[] = ((Container) parent).getComponents();
			for (int i = 0; i < components.length; i++) {
				Component comp = components[i];
				if (comp != null && comp.isVisible()) {
					Point loc = comp.getLocation();
					if (comp instanceof Container) {
						comp =
							getDeepestComponentAt(comp, x - loc.x, y - loc.y);
					} else {
						comp = comp.getComponentAt(x - loc.x, y - loc.y);
					}
					if (comp != null
						&& comp.isVisible()
						&& !(comp instanceof LayerVisualComponent)) {
						return comp;
					}
				}
			}
		}
		return parent;
	}
}
