/*
 * BlowVisualComponent.java
 * Created on 2003/10/18
 * 
 * Copyright (c) 2003 CreW Project. All rights reserved.
 */
package jp.ac.keio.sfc.crew.swing.visuals;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;

import javax.swing.BorderFactory;
import javax.swing.JLabel;

/**
 * Class BlowVisualComponent.
 * 
 * @author macchan
 * @version $Id: BlowVisualComponent.java,v 1.1 2003/12/11 10:27:01 macchan Exp $
 */
public class BlowVisualComponent extends VisualComponent {

	private BasicStroke stroke = new BasicStroke(2);
	private JLabel label = new JLabel();

	/**
	 * Constructor for BlowVisualComponent.
	 */
	public BlowVisualComponent() {
		setLayout(new FlowLayout());
		setForeground(Color.BLACK);
		setBackground(Color.WHITE);
		setBorder(BorderFactory.createEmptyBorder(2, 8, 2, 8));
		add(label);
	}

	/* (non-Javadoc)
	 * @see javax.swing.JComponent#paintComponent(java.awt.Graphics)
	 */
	protected void paintVisual(Graphics2D g) {

		//Draw Background
		int x = 0;
		int y = 0;
		int w = getWidth();
		int h = getHeight();

		//Draw Foreground
		int lw = (int) stroke.getLineWidth();
		int dx = x + lw / 2;
		int dy = y + lw / 2;
		int dw = w - lw - 1;
		int dh = h - lw - 1;

		Shape shape = new Arc2D.Double(dx, dy, dw, dh, -120, 330, Arc2D.OPEN);
		GeneralPath generalPath = new GeneralPath(shape);
		generalPath.lineTo(dx, dh);
		generalPath.closePath();
		shape = generalPath;

		if (getBackground() != null) {
			g.setColor(getBackground());
			g.fill(shape);
		}

		if (getForeground() != null) {
			g.setStroke(stroke);
			g.setColor(getForeground());
			g.draw(shape);
		}
	}

	public void setText(String text) {
		label.setText(text);
		validate();
	}

	/**
	 * Method getLabel.
	 * @return
	 */
	public JLabel getLabel() {
		return label;
	}

}
