/*
 * Decoration.java
 * Created on 2003/10/15
 * 
 * Copyright (c) 2003 CreW Project. All rights reserved.
 */
package jp.ac.keio.sfc.crew.swing.visuals;

import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;

/**
 * Class Decoration.
 * 
 * @author macchan
 * @version $Id: Decoration.java,v 1.1 2003/12/11 10:27:01 macchan Exp $
 */
public class Decoration {

	public static final Shape DEFAULT_TEMPLATE = new Rectangle(0, 0, 0, 0);

	public static final Decoration createTriangleInstance() {
		Polygon triangle = new Polygon();
		triangle.addPoint(-1, 1);
		triangle.addPoint(1, 0);
		triangle.addPoint(-1, -1);

		Decoration decoration = new Decoration();
		decoration.setTemplate(triangle);
		return decoration;
	}

	private Shape template = DEFAULT_TEMPLATE;
	private double sx = 10d, sy = 10d;
	private double lx = 0d, ly = 0d;
	private double direction = 0d;

	private boolean dirty = true;
	private Shape cash = null;

	/**
	 * Constructor for Decoration.
	 */
	public Decoration() {
	}

	public void setTemplate(Shape shape) {
		template = shape;

		this.dirty = true;
	}

	public Shape getShape() {
		if (dirty) {
			recreateShape();
			this.dirty = false;
		}
		return cash;
	}

	private void recreateShape() {
		AffineTransform transform = new AffineTransform();
		transform.translate(lx, ly);
		transform.rotate(direction);
		transform.scale(sx, sy);
		cash = transform.createTransformedShape(template);
	}

	public void setScale(double sx, double sy) {
		this.sx = sx;
		this.sy = sy;

		this.dirty = true;
	}

	public void setLocation(double lx, double ly) {
		this.lx = lx;
		this.ly = ly;

		this.dirty = true;
	}

	public void setDirection(double dx, double dy) {
		setDirection(Math.atan2(dy, dx));
	}

	public void setDirection(double angle) {
		this.direction = angle;

		this.dirty = true;
	}

}
