/*
 * ImageVisualComponent.java
 * Created on 2003/10/15
 * 
 * Copyright (c) 2003 CreW Project. All rights reserved.
 */
package jp.ac.keio.sfc.crew.swing.visuals;

import java.awt.Graphics2D;
import java.awt.Image;


/**
 * Class ImageVisualComponent.
 * 
 * @author macchan
 * @version $Id: ImageVisualComponent.java,v 1.1 2003/12/11 10:27:01 macchan Exp $
 */
public class ImageVisualComponent extends VisualComponent {

	/*************************************
	 * Instance Variables.
	 *************************************/

	private Image image = null;

	/*************************************
	 * Constructors.
	 *************************************/

	/**
	 * Constructor for ImageVisualComponent.
	 */
	public ImageVisualComponent() {
	}

	/**
	 * Constructor for ImageVisualComponent.
	 */
	public ImageVisualComponent(Image image) {
		setImage(image);
	}

	/*************************************
	 * Paint Strategy.
	 *************************************/

	/**
	 * @see jp.ac.keio.sfc.crew.swing.visuals.VisualComponent#paintVisual(java.awt.Graphics2D)
	 */
	protected void paintVisual(Graphics2D g) {
		super.paintVisual(g);
		g.drawImage(image, 0, 0, getWidth(), getHeight(), this);
	}

	/*************************************
	 * Getters and Setters.
	 *************************************/

	/**
	 * @return
	 */
	public Image getImage() {
		return image;
	}

	/**
	 * @param image
	 */
	public void setImage(Image image) {
		if (image != null) {
			this.image = image;
			int w = image.getWidth(this);
			int h = image.getHeight(this);
			setSize(w, h);
		}
	}

}
