/*
 * LabelVisualComponent.java
 * Created on 2003/10/18
 * 
 * Copyright (c) 2003 CreW Project. All rights reserved.
 */
package jp.ac.keio.sfc.crew.swing.visuals;

import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Graphics2D;

import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;

/**
 * Class LabelVisualComponent.
 * 
 * @author macchan
 * @version $Id: LabelVisualComponent.java,v 1.2 2004/03/19 08:26:05 macchan Exp $
 */
public class LabelVisualComponent extends VisualComponent {

	private JLabel label = new JLabel();

	/**
	 * Constructor for LabelVisualComponent.
	 */
	public LabelVisualComponent() {
		setLayout(new FlowLayout());
		setForeground(Color.BLACK);
		setBackground(Color.WHITE);
		setBorder(BorderFactory.createEmptyBorder(2, 8, 2, 8));
		add(label);
	}

	/* (non-Javadoc)
	 * @see javax.swing.JComponent#paintComponent(java.awt.Graphics)
	 */
	protected void paintVisual(Graphics2D g) {
	}

	public void setText(String text) {
		label.setText(text);
		validate();
	}

	public void setIcon(Icon icon) {
		label.setIcon(icon);
		validate();
	}

	public void setLabelOpaque(boolean opaque) {
		label.setOpaque(opaque);
		if (opaque == true) {
			label.setBackground(getBackground());
		}
	}

	/**
	 * Method getLabel.
	 * @return
	 */
	public JLabel getLabel() {
		return label;
	}

}
