/*
 * LightWeightLayerVisualComponent.java
 * Created on 2003/10/19
 * 
 * Copyright (c) 2003 CreW Project. All rights reserved.
 */
package jp.ac.keio.sfc.crew.swing.visuals;

import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;

/**
 * Class LightWeightLayerVisualComponent.
 * 
 * @author macchan
 * @version $Id: LightWeightLayerVisualComponent.java,v 1.1 2003/12/11 10:27:01 macchan Exp $
 */
public class LightWeightLayerVisualComponent extends LayerVisualComponent {

	private List components = new ArrayList();
	private BufferedImage cash = null;

	/**
	 * Constructor for LightWeightLayerVisualComponent.
	 */
	public LightWeightLayerVisualComponent() {
		super();
	}

	/****************************************
	 * Override
	 ****************************************/

	protected void addImpl(Component comp, Object constraints, int index) {
		synchronized (getTreeLock()) {
			if (index == -1) {
				components.add(comp);
			} else {
				components.add(index, comp);
			}

			if (comp instanceof VisualComponent) {
				VisualComponent visual = (VisualComponent) comp;
				if (visual.getParentVisual() != null) {
					visual.getParentVisual().remove(comp);
				}
				visual.setParentVisual(this);
			}
			repaint();
		}
	}

	public void remove(int index) {
		synchronized (getTreeLock()) {
			components.remove(index);
			repaint();
		}
	}

	public void remove(Component comp) {
		synchronized (getTreeLock()) {
			components.remove(comp);
			repaint();
		}
	}

	public void removeAll() {
		synchronized (getTreeLock()) {
			components.clear();
			repaint();
		}
	}

	/****************************************
	 * Paint Strategy
	 ****************************************/

	//	public void repaint() {
	//		if (getParentVisual() != null
	//			&& getParentVisual() instanceof LightWeightLayerVisualComponent) {
	//			getParentVisual().repaint();
	//		} else if (getWidth() > 0 && getHeight() > 0) {
	//			cash =
	//				new BufferedImage(
	//					getWidth(),
	//					getHeight(),
	//					BufferedImage.TYPE_4BYTE_ABGR);
	//			paintVisual((Graphics2D) cash.getGraphics());
	//			System.out.println("Hoge");
	//		} else {
	//			super.repaint();
	//		}
	//	}
	//
	//	public void paint(Graphics g) {
	//		if (cash != null) {
	//			((Graphics2D) g).drawImage(cash, null, 0, 0);
	//		} else {
	//			super.paint(g);
	//		}
	//	}

	/* (non-Javadoc)
	 * @see javax.swing.JComponent#paintComponent(java.awt.Graphics)
	 */
	protected void paintVisual(Graphics2D g) {
		int size = components.size();
		for (int i = 0; i < size; i++) {
			Component component = (Component) components.get(i);
			if (component.isVisible()
				&& component instanceof VisualComponent) {
				((VisualComponent) component).paintVisual(g);
			}
		}
	}

}
