/*
 * RectangleVisualComponent.java
 * Created on 2003/10/12
 * 
 * Copyright (c) 2003 CreW Project. All rights reserved.
 */
package jp.ac.keio.sfc.crew.swing.visuals;

import java.awt.BasicStroke;
import java.awt.Graphics2D;

/**
 * Class RectangleVisualComponent.
 * 
 * @author macchan
 * @version $Id: RectangleVisualComponent.java,v 1.1 2003/12/11 10:27:01 macchan Exp $
 */
public class RectangleVisualComponent extends VisualComponent {

	private BasicStroke stroke = new BasicStroke(1);

	/**
	 * Constructor for RectangleVisualComponent.
	 */
	public RectangleVisualComponent() {
	}

	public void setLineWidth(float width) {
		stroke = new BasicStroke(width);
	}

	/* (non-Javadoc)
	 * @see jp.ac.keio.sfc.crew.view.sgef.visuals.SVisualComponent#paintVisual(java.awt.Graphics2D)
	 */
	protected void paintVisual(Graphics2D g) {

		//Draw Background
		int x = 0;
		int y = 0;
		int w = getWidth();
		int h = getHeight();

		if (getBackground() != null) {
			g.setColor(getBackground());
			g.fillRect(x, y, w, h);
		}

		//Draw Foreground
		int lw = (int) stroke.getLineWidth();
		int dx = x + lw / 2;
		int dy = y + lw / 2;
		int dw = w - lw - 1;
		int dh = h - lw - 1;

		if (getForeground() != null) {
			g.setStroke(stroke);
			g.setColor(getForeground());
			g.drawRect(dx, dy, dw, dh);
		}

	}

}
