/*
 * CThreadEvent.java
 * Created on 2003/10/17
 * 
 * Copyright (c) 2003 CreW Project. All rights reserved.
 */
package jp.ac.keio.sfc.crew.thread;

import java.util.EventObject;

/**
 * Class CThreadEvent.
 * 
 * @author macchan
 * @version $Id: CThreadEvent.java,v 1.1 2003/12/11 10:26:50 macchan Exp $
 */
public class CThreadEvent extends EventObject {

	/**************************************
	 * Instance Variables
	 **************************************/

	private int state;
	private Throwable ex;

	/**************************************
	 * Constructors.
	 **************************************/

	/**
	 * Constructor for CThreadEvent.
	 */
	public CThreadEvent(Object source, int state) {
		this(source, state, null);
	}

	/**
	 * Constructor for CThreadEvent.
	 */
	public CThreadEvent(Object source, int state, Throwable ex) {
		super(source);
		this.state = state;
		this.ex = ex;
	}

	/**************************************
	 * Getters.
	 **************************************/

	/**
	 * Method getExexption.
	 * @return
	 */
	public Throwable getException() {
		return ex;
	}

	/**
	 * Method getState.
	 * @return
	 */
	public int getState() {
		return state;
	}

	/**************************************
	 * Utilities.
	 **************************************/

	public boolean isStarting() {
		return this.state == CThread.STARTING;
	}

	public boolean isRunning() {
		return this.state == CThread.RUNNING;
	}

	public boolean isStopping() {
		return this.state == CThread.STOPPING;
	}

	public boolean isStopped() {
		return this.state == CThread.STOPPED;
	}

}
