/*
 * SEditor.java
 * Created on 2003/10/12
 * 
 * Copyright (c) 2003 CreW Project. All rights reserved.
 */
package jp.ac.keio.sfc.crew.view.sgef;

import javax.swing.JPanel;

import jp.ac.keio.sfc.crew.swing.visuals.VisualComponent;
import jp.ac.keio.sfc.crew.view.sgef.editparts.SEditPart;
import jp.ac.keio.sfc.crew.view.sgef.editparts.SEditPartFactory;

/**
 * Class SEditor.
 * 
 * @author macchan
 * @version $Id: SEditor.java,v 1.1 2003/12/11 10:26:57 macchan Exp $
 */
public class SEditor extends JPanel {

	/***********************************
	 * Instance Variables.
	 ***********************************/

	private SEditPart rootEditPart;

	private SEditPartFactory editPartFactory;
	private SEditPartManager editpartManager = new SEditPartManager();

	/***********************************
	 * Constructors.
	 ***********************************/

	/**
	 * Constructor for SEditor.
	 */
	public SEditor() {
		initialize();
	}

	/***********************************
	 * Initializers.
	 ***********************************/

	private void initialize() {
		initializeComponent();
		initializeComponents();
	}

	protected void initializeComponent() {
	}

	protected void initializeComponents() {
	}

	/***********************************
	 * Visible and Activate
	 ***********************************/

	public void setVisible(boolean visible) {
		super.setVisible(visible);
		rootEditPart.setActive(visible);
	}

	/***********************************
	 * for EditPartFactory
	 ***********************************/

	/**
	 * @return
	 */
	public SEditPartFactory getEditPartFactory() {
		return editPartFactory;
	}

	/**
	 * @param factory
	 */
	public void setEditPartFactory(SEditPartFactory factory) {
		editPartFactory = factory;
	}

	/***********************************
	 * for RootEditPart
	 ***********************************/

	/**
	 * @return
	 */
	public SEditPart getRootEditPart() {
		return rootEditPart;
	}

	/**
	 * @param part
	 */
	public void setRootEditPart(SEditPart root) {
		if (rootEditPart != null) {
			rootEditPart.setActive(false);
			rootEditPart.setEditor(null);
		}

		rootEditPart = root;

		if (rootEditPart != null) {
			rootEditPart.setEditor(this);
			rootEditPart.setActive(isVisible());
		}
	}

	/***********************************
	 * Delegation to ElementManager
	 ***********************************/

	public void registerEditPart(SEditPart parent, SEditPart editpart) {
		this.editpartManager.registerEditPart(parent, editpart);
	}

	public void unregisterEditPart(SEditPart parent, SEditPart editpart) {
		this.editpartManager.unregisterEditPart(parent, editpart);
	}

	public SEditPart getEditPart(VisualComponent visual) {
		return editpartManager.getEditPart(visual);
	}

	public SEditPart getEditPart(Object model) {
		return editpartManager.getEditPart(model);
	}

}