/*
 * SGraphicalEditor.java
 * Created on 2003/10/16
 * 
 * Copyright (c) 2003 CreW Project. All rights reserved.
 */
package jp.ac.keio.sfc.crew.view.sgef;

import java.awt.BorderLayout;
import java.awt.Color;
import java.util.List;

import javax.swing.JComponent;
import javax.swing.JScrollPane;

import jp.ac.keio.sfc.crew.swing.visuals.LayerVisualComponent;
import jp.ac.keio.sfc.crew.view.sgef.editparts.SEditPart;

/**
 * Class SGraphicalEditor.
 * 
 * @author macchan
 * @version $Id: SGraphicalEditor.java,v 1.1 2003/12/11 10:26:57 macchan Exp $
 */
public class SGraphicalEditor extends SEditor {

	private SSelectionManager selectionManager = new SSelectionManager(this);

	private JScrollPane scroll;
	private JComponent rootLayer;
	private JComponent selectionLayer;
	private JComponent animationLayer;
	private JComponent contentsLayer;

	/**
	 * Constructor for SGraphicalEditor.
	 */
	public SGraphicalEditor() {
		super();
	}

	protected void initializeComponent() {
		this.setLayout(new BorderLayout());
	}

	protected void initializeComponents() {
		scroll = new JScrollPane();
		add(scroll);

		rootLayer = new LayerVisualComponent();
		rootLayer.setBackground(Color.WHITE);
		rootLayer.setOpaque(true);
		scroll.getViewport().add(rootLayer);

		selectionLayer = new LayerVisualComponent();
		rootLayer.add(selectionLayer);

		animationLayer = new LayerVisualComponent();
		rootLayer.add(animationLayer);

		contentsLayer = new LayerVisualComponent();
		rootLayer.add(contentsLayer);

		rootLayer.setSize(800, 800);
	}

	/***********************************
	 * Getters for Layers.
	 ***********************************/

	/**
	 * @return
	 */
	public JComponent getSelectionLayer() {
		return selectionLayer;
	}

	/**
	 * @return
	 */
	public JComponent getAnimationLayer() {
		return animationLayer;
	}

	/**
	 * @return
	 */
	public JComponent getContentsLayer() {
		return contentsLayer;
	}

	/**
	 * @return
	 */
	public JComponent getRootLayer() {
		return rootLayer;
	}

	/**
	 * @return
	 */
	public JComponent getViewportLayer() {
		return scroll.getViewport();
	}

	/***********************************
	 * Delegation to SelectionManager
	 ***********************************/

	public void addSelectedEditPart(SEditPart editpart) {
		selectionManager.add(editpart);
	}

	public void clearSelection() {
		selectionManager.clearSelection();
	}

	public List getSelectedEditParts() {
		return selectionManager.getSelectedEditParts();
	}

	public boolean hasSelectedEditPart() {
		return selectionManager.hasSelectedEditPart();
	}

}
