/*
 * SSelectionManager.java
 * Created on 2003/10/12
 * 
 * Copyright (c) 2003 CreW Project. All rights reserved.
 */
package jp.ac.keio.sfc.crew.view.sgef;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import jp.ac.keio.sfc.crew.collection.ListCoordinator;
import jp.ac.keio.sfc.crew.collection.ValueChangeListener;
import jp.ac.keio.sfc.crew.view.sgef.editparts.SEditPart;
import jp.ac.keio.sfc.crew.view.sgef.ext.editparts.EGraphicalEditPart;

/**
 * Class SSelectionManager.
 * 
 * @author macchan
 * @version $Id: SSelectionManager.java,v 1.1 2003/12/11 10:26:57 macchan Exp $
 */
public class SSelectionManager {

	private SGraphicalEditor editor;

	private ListCoordinator coordinator =
		new ListCoordinator(new SelectionValueChangeListener());
	private Map selectedEditParts = new LinkedHashMap();

	/**
	 * Constructor for SSelectionManager.
	 */
	public SSelectionManager(SGraphicalEditor editor) {
		this.editor = editor;
	}

	public void add(SEditPart editpart) {
		if (editpart != null && !selectedEditParts.containsKey(editpart)) {
			List list = this.coordinator.getList();
			list.add(editpart);
			this.coordinator.setList(list);
		}
	}

	public void clearSelection() {
		this.coordinator.setList(null);
	}

	public List getSelectedEditParts() {
		return new ArrayList(selectedEditParts.keySet());
	}

	public boolean hasSelectedEditPart() {
		return !getSelectedEditParts().isEmpty();
	}

	private void addSelection(SEditPart editpart) {
		synchronized (editor.getTreeLock()) {
			selectedEditParts.put(editpart, null);
			if (editpart instanceof EGraphicalEditPart) {
				((EGraphicalEditPart) editpart).addHandle();
			}
		}
	}

	private void removeSelection(SEditPart editpart) {
		synchronized (editor.getTreeLock()) {
			selectedEditParts.remove(editpart);
			if (editpart instanceof EGraphicalEditPart) {
				((EGraphicalEditPart) editpart).removeHandle();
			}
		}
	}

	class SelectionValueChangeListener implements ValueChangeListener {

		/* (non-Javadoc)
		* @see jp.ac.keio.sfc.crew.util.ValueChangeListener#valueAdded(java.lang.Object, int)
		*/
		public void valueAdded(Object model, int index) {
			addSelection((SEditPart) model);
		}

		/* (non-Javadoc)
		 * @see jp.ac.keio.sfc.crew.util.ValueChangeListener#valueRemoved(java.lang.Object)
		 */
		public void valueRemoved(Object model) {
			removeSelection((SEditPart) model);
		}

		/* (non-Javadoc)
		 * @see jp.ac.keio.sfc.crew.util.ValueChangeListener#valueReorderd(java.lang.Object, int)
		 */
		public void valueReorderd(Object model, int index) {
		}
	}

}
