/*
 * AbstractAnimationThread.java
 * Created on 2003/10/25
 * 
 * Copyright (c) 2003 CreW Project. All rights reserved.
 */
package jp.ac.keio.sfc.crew.view.sgef.animation;

import jp.ac.keio.sfc.crew.thread.CThread;

/**
 * Class AbstractAnimationThread.
 * 
 * @author macchan
 * @version $Id: AbstractAnimationThread.java,v 1.1 2003/12/11 10:26:47 macchan Exp $
 */
public abstract class AbstractAnimationThread extends CThread {

	/**************************************
	 * Constants.
	 **************************************/

	public static final int PERMANENT = -1;

	/**************************************
	 * Instance Variables.
	 **************************************/

	private boolean enable = true;
	private boolean loop;

	private int stepCount = PERMANENT;

	/**
	 * Constructor for AbstractAnimationThread.
	 */
	public AbstractAnimationThread() {
		super();
	}

	/**
	 * @see jp.ac.keio.sfc.crew.thread.CThread#start()
	 */
	public boolean start() {
		if (!enable) {
			return false;
		} else {
			return super.start();
		}
	}

	/**
	 * Method isEnable.
	 * @return
	 */
	public boolean isEnable() {
		return enable;
	}

	/**
	 * Method setEnable.
	 * @param b
	 */
	public void setEnable(boolean enable) {
		this.enable = enable;
		if (this.enable && !enable && getState() == RUNNING) {
			setState(STOPPING);
		}
	}

	/**
	 * Method isLoop.
	 * @return
	 */
	public boolean isLoop() {
		return loop;
	}

	/**
	 * Method setLoop.
	 * @param b
	 */
	public void setLoop(boolean loop) {
		this.loop = loop;
	}

	/**
	 * Method getStepCount.
	 * @return
	 */
	public int getStepCount() {
		return stepCount;
	}

	/**
	 * Method setStepCount.
	 * @param i
	 */
	public void setStepCount(int stepCount) {
		this.stepCount = stepCount;
	}

}
