/*
 * AbstractBlinkingAnimationThread.java
 * Created on 2003/10/24
 * 
 * Copyright (c) 2003 CreW Project. All rights reserved.
 */
package jp.ac.keio.sfc.crew.view.sgef.animation;

import java.awt.Color;

import jp.ac.keio.sfc.crew.swing.visuals.VisualComponent;

/**
 * Class AbstractBlinkingAnimationThread.
 * 
 * @author macchan
 * @version $Id: AbstractBlinkingAnimationThread.java,v 1.1 2003/12/11 10:26:47 macchan Exp $
 */
public abstract class AbstractBlinkingAnimationThread
	extends AbstractAnimationThread {

	/**************************************
	 * Constants.
	 **************************************/

	public static final boolean ON = true;
	public static final boolean OFF = false;

	/**************************************
	 * Instance Variables.
	 **************************************/

	private VisualComponent visual;

	private Color bgColor = Color.red;
	private Color fgColor = Color.red;

	private boolean blinkingState = OFF;
	private int currentStep = 0;
	private Color defaultBgColor;
	private Color defaultFgColor;

	/**************************************
	 * Constructors.
	 **************************************/

	/**
	 * Constructor for ShapeBlinkingAnimationThread.
	 */
	public AbstractBlinkingAnimationThread() {
		super();
	}

	/**************************************
	 * Animation Strategy.
	 **************************************/

	/**
	 * @see jp.ac.keio.sfc.crew.thread.CThread#step()
	 */
	protected void step() {
		if (getStepCount() != PERMANENT
			&& currentStep >= getStepCount()
			&& !isLoop()) {
			this.setState(STOPPING);
		}
		blinkingState = !blinkingState;
		setColor();
		currentStep++;
	}

	/**
	 * @see jp.ac.keio.sfc.crew.thread.CThread#prepareStart()
	 */
	protected void prepareStart() {
		currentStep = 0;
		blinkingState = ON;
		if (visual != null) {
			defaultFgColor = visual.getForeground();
			defaultBgColor = visual.getBackground();
		}
		setColor();
	}

	/**
	 * @see jp.ac.keio.sfc.crew.thread.CThread#prepareStop()
	 */
	protected void prepareStop() {
		blinkingState = OFF;
		setColor();
	}

	protected abstract void setColor();

	/**************************************
	 * Getters and Setters.
	 **************************************/

	/**
	 * Method getVisual.
	 * @return
	 */
	public VisualComponent getVisual() {
		return visual;
	}

	/**
	 * Method setVisual.
	 * @param component
	 */
	public void setVisual(VisualComponent component) {
		visual = component;
	}

	/**
	 * Method getBgColor.
	 * @return
	 */
	public Color getBgColor() {
		return bgColor;
	}

	/**
	 * Method getFgColor.
	 * @return
	 */
	public Color getFgColor() {
		return fgColor;
	}

	/**
	 * Method setBgColor.
	 * @param color
	 */
	public void setBgColor(Color color) {
		bgColor = color;
	}

	/**
	 * Method setFgColor.
	 * @param color
	 */
	public void setFgColor(Color color) {
		fgColor = color;
	}

	/**
	 * Method getBlinkingState.
	 * @return
	 */
	public boolean getBlinkingState() {
		return blinkingState;
	}

	/**
	 * Method getDefaultBgColor.
	 * @return
	 */
	public Color getDefaultBgColor() {
		return defaultBgColor;
	}

	/**
	 * Method getDefaultFgColor.
	 * @return
	 */
	public Color getDefaultFgColor() {
		return defaultFgColor;
	}

}
