/*
 * CoverBlinkingAnimationThread.java
 * Created on 2003/10/24
 * 
 * Copyright (c) 2003 CreW Project. All rights reserved.
 */
package jp.ac.keio.sfc.crew.view.sgef.animation;

import java.awt.Color;

import jp.ac.keio.sfc.crew.swing.SwingUtil;
import jp.ac.keio.sfc.crew.swing.visuals.RectangleVisualComponent;
import jp.ac.keio.sfc.crew.swing.visuals.VisualComponent;
import jp.ac.keio.sfc.crew.view.sgef.ext.editparts.EAnimationEditPart;
import jp.ac.keio.sfc.crew.view.sgef.ext.editparts.EGraphicalEditPart;

/**
 * Class CoverBlinkingAnimationThread.
 * 
 * @author macchan
 * @version $Id: CoverBlinkingAnimationThread.java,v 1.1 2003/12/11 10:26:47 macchan Exp $
 */
public class CoverBlinkingAnimationThread
	extends AbstractBlinkingAnimationThread {

	private EGraphicalEditPart parent;
	private RectangleVisualComponent visual = new RectangleVisualComponent();
	private CoverEditPart cover = new CoverEditPart();
	private Color color = SwingUtil.createAlphaedColor(Color.RED, 100);

	/**
	 * Constructor for CoverBlinkingAnimationThread.
	 */
	public CoverBlinkingAnimationThread() {
	}

	/**
	 * @see jp.ac.keio.sfc.crew.thread.CThread#prepareStart()
	 */
	protected void prepareStart() {
		if (parent != null) {
			visual.setVisible(true);
			visual.setForeground(SwingUtil.COLOR_OPAQUE);
			visual.setBackground(color);
			parent.addTemporaryAccessories(cover);
			cover.setEditor(parent.getEditor());
			cover.setParent(parent);
			cover.setActive(true);
			cover.refreshVisual();
		}
		super.prepareStart();
	}

	/**
	 * @see jp.ac.keio.sfc.crew.thread.CThread#prepareStart()
	 */
	protected void prepareStop() {
		super.prepareStop();
		if (parent != null) {
			cover.setActive(false);
			parent.removeTemporaryAccessories(cover);
		}
	}

	/**
	 * @see jp.ac.keio.sfc.crew.view.sgef.animation.AbstractBlinkingAnimationThread#setColor()
	 */
	protected void setColor() {
		if (visual != null) {
			synchronized (visual.getTreeLock()) {
				if (getBlinkingState() == OFF) {
					visual.setVisible(false);
				} else {
					visual.setVisible(true);
				}
			}
		}
	}

	/**
	 * Method getParent.
	 * @return
	 */
	public EGraphicalEditPart getParent() {
		return parent;
	}

	/**
	 * Method setParent.
	 * @param part
	 */
	public void setParent(EGraphicalEditPart part) {
		parent = part;
	}

	class CoverEditPart extends EAnimationEditPart {

		/**
		* @see jp.ac.keio.sfc.crew.view.sgef.editparts.SEditPart#createVisual()
		*/
		protected VisualComponent createVisual() {
			return visual;
		}

		public void refreshVisual() {
			VisualComponent parentVisual = getParent().getVisual();
			visual.setLocation(parentVisual.getAbsoluteLocation());
			visual.setSize(parentVisual.getSize());
		}

	}

	/**
	 * Method getColor.
	 * @return
	 */
	public Color getColor() {
		return color;
	}

	/**
	 * Method setColor.
	 * @param color
	 */
	public void setColor(Color color) {
		this.color = color;
	}

}
