/*
 * LinePath.java
 * Created on 2003/10/17
 * 
 * Copyright (c) 2003 CreW Project. All rights reserved.
 */
package jp.ac.keio.sfc.crew.view.sgef.animation;

import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;

/**
 * Class LinePath.
 * 
 * @author macchan
 * @version $Id: LinePath.java,v 1.1 2003/12/11 10:26:47 macchan Exp $
 */
public class LinePath implements Path {

	/******************************
	 * Instance Variables.
	 ******************************/

	private Line2D line;
	private AffineTransform transform;
	private boolean reverse = false;

	/******************************
	 * Constructors.
	 ******************************/

	/**
	 * Constructor for LinePath.
	 */
	public LinePath(Line2D line) {
		this(line, null);
	}

	/**
	 * Constructor for LinePath.
	 */
	public LinePath(Line2D line, AffineTransform transform) {
		this.line = line;
		this.transform = transform;
	}

	/******************************
	 * Generate Point strategy
	 ******************************/

	/**
	 * @see jp.ac.keio.sfc.crew.view.sgef.animation.Path#getPoint(int)
	 */
	public Point getPoint(int percentage) {

		if (percentage > 100) {
			percentage = 100;
		}
		if (percentage < 0) {
			percentage = 0;
		}

		double ratio = (double) percentage / 100d;

		double x1 = line.getX1();
		double y1 = line.getY1();
		double x2 = line.getX2();
		double y2 = line.getY2();

		if (isReverse()) {
			x1 = line.getX2();
			y1 = line.getY2();
			x2 = line.getX1();
			y2 = line.getY1();
		}

		double dx = (x2 - x1) * ratio;
		double dy = (y2 - y1) * ratio;

		Point p = new Point((int) (x1 + dx), (int) (y1 + dy));
		if (transform != null) {
			p.translate(
				(int) transform.getTranslateX(),
				(int) transform.getTranslateY());
		}
		return p;
	}

	/******************************
	 * Getter and Setters
	 ******************************/

	/**
	 * Method getLine.
	 * @return
	 */
	public Line2D getLine() {
		return line;
	}

	/**
	 * Method getTransform.
	 * @return
	 */
	public AffineTransform getTransform() {
		return transform;
	}

	/**
	 * Method setLine.
	 * @param line2D
	 */
	public void setLine(Line2D line2D) {
		line = line2D;
	}

	/**
	 * Method setTransform.
	 * @param transform
	 */
	public void setTransform(AffineTransform transform) {
		this.transform = transform;
	}

	/**
	 * Method isReverse.
	 * @return
	 */
	public boolean isReverse() {
		return reverse;
	}

	/**
	 * Method setReverse.
	 * @param b
	 */
	public void setReverse(boolean reverse) {
		this.reverse = reverse;
	}

	/**
	 * Method Reverse.
	 * @param b
	 */
	public void reverse() {
		this.reverse = !this.reverse;
	}

}
