/*
 * MovingAnimationThread.java
 * Created on 2003/10/17
 * 
 * Copyright (c) 2003 CreW Project. All rights reserved.
 */
package jp.ac.keio.sfc.crew.view.sgef.animation;

import jp.ac.keio.sfc.crew.swing.visuals.VisualComponent;

/**
 * Class MovingAnimationThread.
 * 
 * @author macchan
 * @version $Id: MovingAnimationThread.java,v 1.1 2003/12/11 10:26:47 macchan Exp $
 */
public class MovingAnimationThread extends AbstractAnimationThread {

	/**************************************
	 * Instance Variables.
	 **************************************/

	private VisualComponent visual;
	private Path path;

	private double currentPosition;

	/**************************************
	 * Constructors.
	 **************************************/

	/**
	 * Constructor for MovingAnimationThread.
	 */
	public MovingAnimationThread() {
	}

	/**************************************
	 * Animation Strategy.
	 **************************************/

	/**
	 * @see jp.ac.keio.sfc.crew.thread.CThread#step()
	 */
	protected void step() {
		//Move Position
		currentPosition += 1.0d / (double) getStepCount();

		//Move Location
		if (visual != null && path != null) {
			synchronized (visual.getTreeLock()) {
				visual.setLocationByCenter(
					path.getPoint((int) (currentPosition * 100)));
				visual.repaint();
				visualMoved();
			}
		}

		//Reset Position Or End Animation.
		if (currentPosition > 1.0d) {
			if (isLoop()) {
				resetCurrentPosition();
			} else {
				setState(STOPPING);
			}
		}
	}

	/**
	 * @see jp.ac.keio.sfc.crew.thread.CThread#prepareStart()
	 */
	protected void prepareStart() {
		resetCurrentPosition();
	}

	/**
	 * @see jp.ac.keio.sfc.crew.thread.CThread#prepareStop()
	 */
	protected void prepareStop() {
	}

	/**
	 * Method visualMoved.
	 */
	protected void visualMoved() {
	}

	private void resetCurrentPosition() {
		currentPosition = 0.0d;
	}

	/**************************************
	 * Getters and Setters.
	 **************************************/

	/**
	 * Method getPath.
	 * @return
	 */
	public Path getPath() {
		return path;
	}

	/**
	 * Method getVisual.
	 * @return
	 */
	public VisualComponent getVisual() {
		return visual;
	}

	/**
	 * Method setPath.
	 * @param path
	 */
	public void setPath(Path path) {
		this.path = path;
	}

	/**
	 * Method setVisual.
	 * @param component
	 */
	public void setVisual(VisualComponent component) {
		visual = component;
	}

}
