/*
 * MovingAnimationThreadWithLine.java
 * Created on 2003/10/17
 * 
 * Copyright (c) 2003 CreW Project. All rights reserved.
 */
package jp.ac.keio.sfc.crew.view.sgef.animation;

import jp.ac.keio.sfc.crew.view.sgef.ext.visuals.EConnectionVisualComponent;

/**
 * Class MoveAnimationThreadWithLine.
 * 
 * @author macchan
 * @version $Id: MovingAnimationThreadWithLine.java,v 1.1 2003/12/11 10:26:47 macchan Exp $
 */
public class MovingAnimationThreadWithLine extends MovingAnimationThread {

	/**************************************
	 * Instance Variables.
	 **************************************/

	private EConnectionVisualComponent connection;

	/**************************************
	 * Constructors.
	 **************************************/

	/**
	 * Constructor for MoveAnimationThreadWithLine.
	 */
	public MovingAnimationThreadWithLine() {
	}

	/**************************************
	 * Animation Strategy.
	 **************************************/

	/**
	 * Method visualMoved.
	 */
	protected void visualMoved() {
		if (connection != null) {
			connection.refreshVisual();
		}
	}

	/**
	 * Method getConnection.
	 * @return
	 */
	public EConnectionVisualComponent getConnection() {
		return connection;
	}

	/**
	 * Method setConnection.
	 * @param component
	 */
	public void setConnection(EConnectionVisualComponent component) {
		connection = component;
	}

}
