/*
 * ShapeBlinkingAnimationThread.java
 * Created on 2003/10/18
 * 
 * Copyright (c) 2003 CreW Project. All rights reserved.
 */
package jp.ac.keio.sfc.crew.view.sgef.animation;

import jp.ac.keio.sfc.crew.swing.visuals.VisualComponent;

/**
 * Class ShapeBlinkingAnimationThread.
 * 
 * @author macchan
 * @version $Id: ShapeBlinkingAnimationThread.java,v 1.1 2003/12/11 10:26:47 macchan Exp $
 */
public class ShapeBlinkingAnimationThread
	extends AbstractBlinkingAnimationThread {

	protected void setColor() {
		VisualComponent visual = getVisual();
		if (visual != null) {
			synchronized (visual.getTreeLock()) {
				if (getBlinkingState() == OFF) {
					visual.setForeground(getDefaultFgColor());
					visual.setBackground(getDefaultBgColor());
				} else {
					visual.setForeground(getFgColor());
					visual.setBackground(getBgColor());
				}
				visual.repaint();
			}
		}
	}

}
