/*
 * SEditPart.java
 * Created on 2003/10/10
 * 
 * Copyright (c) 2003 CreW Project. All rights reserved.
 */
package jp.ac.keio.sfc.crew.view.sgef.editparts;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import javax.swing.JComponent;

import jp.ac.keio.sfc.crew.collection.ListCoordinator;
import jp.ac.keio.sfc.crew.collection.ValueChangeListener;
import jp.ac.keio.sfc.crew.swing.visuals.VisualComponent;
import jp.ac.keio.sfc.crew.view.sgef.SEditor;

/**
 * Class SEditPart.
 * 
 * @author macchan
 * @version $Id: SEditPart.java,v 1.1 2003/12/11 10:26:58 macchan Exp $
 */
public abstract class SEditPart {

	/*****************************************
	 * Instance Variables.
	 *****************************************/

	//Relation
	private SEditor editor;
	private SEditPart parent;

	//Composite Relation
	private Object model = new Object();
	private VisualComponent visual;

	//State
	private boolean active = false;

	//Children
	private ListCoordinator childrenCoordinator =
		new ListCoordinator(new ChildrenValueChangeListener());
	private Map childrenTable = new LinkedHashMap();

	/*****************************************
	 * For active
	 *****************************************/

	/**
	 * Constructor for SEditPart.
	 */
	public SEditPart() {
		super();
	}

	/*****************************************
	 * For active
	 *****************************************/

	/**
	 * @return
	 */
	public Object getModel() {
		return model;
	}

	/**
	 * @param object
	 */
	public void setModel(Object object) {
		model = object;
	}

	/**
	 * @return
	 */
	public SEditor getEditor() {
		return editor;
	}

	/**
	 * @param editor
	 */
	public void setEditor(SEditor editor) {
		this.editor = editor;
	}

	/**
	 * @return
	 */
	public SEditPart getParent() {
		return parent;
	}

	/**
	 * @param part
	 */
	public void setParent(SEditPart part) {
		parent = part;
	}

	/*****************************************
	 * For initialize
	 *****************************************/

	protected void initialize() {
	}

	/*****************************************
	 * For active
	 *****************************************/

	public boolean isActive() {
		return active;
	}

	public void setActive(boolean active) {
		thisSetActive(active);
		childrenSetActive(active);
	}

	protected void childrenSetActive(boolean active) {
		for (Iterator i = getChildren().iterator(); i.hasNext();) {
			SEditPart child = (SEditPart) i.next();
			child.setActive(active);
		}
	}

	protected void thisSetActive(boolean active) {
		if (!this.active && active) {
			this.active = true;
			activate();
		} else if (this.active && !active) {
			deactivate();
			this.active = false;
		}
	}

	protected void activate() {
		refresh();
	}

	protected void deactivate() {
	}

	/*****************************************
	 * For Refresh
	 *****************************************/

	public void refresh() {
		refreshRecursively();
	}

	public void refreshRecursively() {
		refreshStructureRecursively();
		refreshVisualRecursively();
	}

	/*****************************************
	 * For Refresh Structure
	 *****************************************/

	public void refreshStructure() {
		refreshChildren();
	}

	public void refreshStructureRecursively() {
		refreshStructure();
		refreshChildrenStructure();
	}

	public void refreshChildrenStructure() {
		for (Iterator i = getChildren().iterator(); i.hasNext();) {
			SEditPart child = (SEditPart) i.next();
			child.refreshStructureRecursively();
		}
	}

	/*****************************************
	 * For Visual
	 *****************************************/

	public VisualComponent getVisual() {
		if (this.visual == null) {
			this.visual = createVisual();
		}
		return this.visual;
	}

	protected abstract VisualComponent createVisual();

	protected VisualComponent getContentPane() {
		return getVisual();
	}

	public void refreshVisual() {
	}

	public void refreshVisualRecursively() {
		refreshVisual();
		refreshChildrenVisual();
	}

	protected void refreshChildrenVisual() {
		for (Iterator i = getChildren().iterator(); i.hasNext();) {
			SEditPart child = (SEditPart) i.next();
			child.refreshVisualRecursively();
		}
	}

	/*****************************************
	 * For Editing
	 *****************************************/

	public boolean isSelectable() {
		return false;
	}

	/*****************************************
	 * For EditPart
	 *****************************************/

	protected SEditPart createOrFindEditPart(Object model) {
		SEditPart editpart = getEditor().getEditPart(model);
		if (editpart == null) {
			editpart = createEditPart(model);
		}
		return editpart;
	}

	protected SEditPart createEditPart(Object model) {
		//Create
		SEditPartFactory factory = getEditor().getEditPartFactory();
		SEditPart editpart = factory.createEditPart(model);
		editpart.setModel(model);

		//Initialize
		initializeEditPart(editpart);

		return editpart;
	}

	protected void initializeEditPart(SEditPart editpart) {
		editpart.setEditor(this.getEditor());
		editpart.setParent(this);
		editpart.initialize();
		getEditor().registerEditPart(this, editpart);
	}

	protected void terminateEditPart(SEditPart editpart) {
		getEditor().unregisterEditPart(this, editpart);
	}

	/*****************************************
	 * For children
	 *****************************************/

	protected List getModelChildren() {
		return null;
	}

	public List getChildren() {
		return new ArrayList(childrenTable.values());
	}

	public void refreshChildren() {
		childrenCoordinator.setList(getModelChildren());
	}

	protected void addChild(SEditPart editpart, int index) {
		//Puts to the table
		childrenTable.put(editpart.getModel(), editpart);

		//Activate		
		editpart.setActive(isActive());

		//Add the Visual
		addChildVisual(editpart, index);
	}

	protected void removeChild(SEditPart editpart) {
		//Remove the Visual
		removeChildVisual(editpart);

		//Deactivate
		editpart.setActive(false);

		//Removes from the table.		
		childrenTable.remove(editpart.getModel());
	}

	protected void reorderChild(SEditPart editpart, int index) {
		removeChildVisual(editpart);
		addChildVisual(editpart, index);
	}

	protected void addChildVisual(SEditPart childEditPart, int index) {
		JComponent childVisual = childEditPart.getVisual();
		getContentPane().add(childVisual, index);
		getContentPane().validate();
	}

	protected void removeChildVisual(SEditPart childEditPart) {
		JComponent childVisual = childEditPart.getVisual();
		getContentPane().remove(childVisual);
		getContentPane().repaint();
	}

	class ChildrenValueChangeListener implements ValueChangeListener {

		/* (non-Javadoc)
		* @see jp.ac.keio.sfc.crew.util.ValueChangeListener#valueAdded(java.lang.Object, int)
		*/
		public void valueAdded(Object model, int index) {
			SEditPart editpart = createOrFindEditPart(model);
			addChild(editpart, index);
		}

		/* (non-Javadoc)
		 * @see jp.ac.keio.sfc.crew.util.ValueChangeListener#valueRemoved(java.lang.Object)
		 */
		public void valueRemoved(Object model) {
			SEditPart editpart = (SEditPart) childrenTable.get(model);
			removeChild(editpart);
			terminateEditPart(editpart);
		}

		/* (non-Javadoc)
		 * @see jp.ac.keio.sfc.crew.util.ValueChangeListener#valueReorderd(java.lang.Object, int)
		 */
		public void valueReorderd(Object model, int index) {
			SEditPart editpart = (SEditPart) childrenTable.get(model);
			reorderChild(editpart, index);
		}
	}

}
