/*
 * SGraphicalEditPart.java
 * Created on 2003/10/13
 * 
 * Copyright (c) 2003 CreW Project. All rights reserved.
 */
package jp.ac.keio.sfc.crew.view.sgef.editparts;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import jp.ac.keio.sfc.crew.collection.ListCoordinator;
import jp.ac.keio.sfc.crew.collection.ValueChangeListener;
import jp.ac.keio.sfc.crew.view.sgef.SGraphicalEditor;

/**
 * Class SGraphicalEditPart.
 * 
 * @author macchan
 * @version $Id: SGraphicalEditPart.java,v 1.1 2003/12/11 10:26:58 macchan Exp $
 */
public abstract class SGraphicalEditPart extends SEditPart {

	/***********************************
	 * Instance Variables
	 ***********************************/

	//For accessories.
	private Map accessoriesTable = new LinkedHashMap();
	private ListCoordinator accessoriesCoordinator =
		new ListCoordinator(new AccessoryValueChangeListener());

	/***********************************
	 * Constructors.
	 ***********************************/

	/**
	 * Constructor for SGraphicalEditPart.
	 */
	public SGraphicalEditPart() {
		super();
	}

	/***********************************
	 * Utility Getters.
	 ***********************************/

	public SGraphicalRootEditPart getRoot() {
		SEditPart editpart = this;
		while (editpart.getParent() != null) {
			editpart = editpart.getParent();
		}
		return (SGraphicalRootEditPart) editpart;
	}

	public SGraphicalEditor getGraphicalEditor() {
		return (SGraphicalEditor) getEditor();
	}

	/***********************************
	 * For Each Attachment Kind. 
	 ***********************************/

	public void setActive(boolean active) {
		thisSetActive(active);
		childrenSetActive(active);
		accessoriesSetActive(active);
	}

	protected void accessoriesSetActive(boolean active) {
		for (Iterator i = getAccessories().iterator(); i.hasNext();) {
			SEditPart accessory = (SEditPart) i.next();
			accessory.setActive(active);
		}
	}

	/*****************************************
	 * For Refresh Structure
	 *****************************************/

	public void refreshStructure() {
		refreshChildren();
		refreshAccessories();
	}

	public void refreshStructureRecursively() {
		refreshStructure();
		refreshChildrenStructure();
		refreshAccessoriesStructure();
	}

	public void refreshAccessoriesStructure() {
		for (Iterator i = getAccessories().iterator(); i.hasNext();) {
			SEditPart child = (SEditPart) i.next();
			child.refreshStructureRecursively();
		}
	}

	/*****************************************
	 * For Visual
	 *****************************************/

	public void refreshVisualRecursively() {
		refreshVisual();
		refreshChildrenVisual();
		refreshAccessoriesVisual();
	}

	public void refreshAccessoriesVisual() {
		for (Iterator i = getAccessories().iterator(); i.hasNext();) {
			SEditPart accessory = (SEditPart) i.next();
			accessory.refreshVisualRecursively();
		}
	}

	/***********************************
	 * For Each Attachment Kind. 
	 ***********************************/

	protected List getModelAccessories() {
		return null;
	}

	/*****************************************
	 * For Attachment
	 *****************************************/

	public void refreshAccessories() {
		accessoriesCoordinator.setList(getModelAccessories());
	}

	public List getAccessories() {
		return new ArrayList(accessoriesTable.values());
	}

	protected void addAttachment(SEditPart editpart) {
		//Puts to the table.
		accessoriesTable.put(editpart.getModel(), editpart);

		//Activate		
		editpart.setActive(isActive());
	}

	protected void removeAttachment(SEditPart editpart) {
		//Terminate
		editpart.setActive(false);

		//Removes from the table.
		accessoriesTable.remove(editpart.getModel());
	}

	class AccessoryValueChangeListener implements ValueChangeListener {

		/* (non-Javadoc)
		* @see jp.ac.keio.sfc.crew.util.ValueChangeListener#valueAdded(java.lang.Object, int)
		*/
		public void valueAdded(Object model, int index) {
			SEditPart editpart = createOrFindEditPart(model);
			addAttachment(editpart);
		}

		/* (non-Javadoc)
		 * @see jp.ac.keio.sfc.crew.util.ValueChangeListener#valueRemoved(java.lang.Object)
		 */
		public void valueRemoved(Object model) {
			SEditPart editpart = (SEditPart) accessoriesTable.get(model);
			if (editpart != null) {
				removeAttachment(editpart);
				terminateEditPart(editpart);
			} else {
				accessoriesTable.remove(model);
			}
		}

		/* (non-Javadoc)
		 * @see jp.ac.keio.sfc.crew.util.ValueChangeListener#valueReorderd(java.lang.Object, int)
		 */
		public void valueReorderd(Object model, int index) {
		}
	}

}
