/*
 * SGraphicalRootEditPart.java
 * Created on 2003/10/12
 * 
 * Copyright (c) 2003 CreW Project. All rights reserved.
 */
package jp.ac.keio.sfc.crew.view.sgef.editparts;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import jp.ac.keio.sfc.crew.swing.visuals.LayerVisualComponent;
import jp.ac.keio.sfc.crew.swing.visuals.VisualComponent;

/**
 * Class SGraphicalRootEditPart.
 * 
 * @author macchan
 * @version $Id: SGraphicalRootEditPart.java,v 1.1 2003/12/11 10:26:58 macchan Exp $
 */
public class SGraphicalRootEditPart extends SGraphicalEditPart {

	/*****************************************
	 * Constants.
	 *****************************************/

	public static final Object LAYER_NODES = "NODES";

	/*****************************************
	 * Instance Variables.
	 *****************************************/

	private Object rootModel;

	private LayerVisualComponent rootLayer = new LayerVisualComponent();
	private Map layerTable = new HashMap();

	/*****************************************
	 * Constructors.
	 *****************************************/

	/**
	 * Constructor for SGraphicalRootEditPart.
	 */
	public SGraphicalRootEditPart() {
		installLayers();
	}

	protected void installLayers() {
		installLayer(LAYER_NODES, new LayerVisualComponent(), 0);
	}

	/*****************************************
	 * Implements for EditPart
	 *****************************************/

	/* (non-Javadoc)
	 * @see jp.ac.keio.sfc.crew.view.sgef.editparts.SEditPart#activate()
	 */
	protected void activate() {
		super.activate();
		getGraphicalEditor().getContentsLayer().add(this.getVisual());
	}

	/* (non-Javadoc)
	 * @see jp.ac.keio.sfc.crew.view.sgef.editparts.SEditPart#deactivate()
	 */
	protected void deactivate() {
		super.deactivate();
		getGraphicalEditor().getContentsLayer().remove(this.getVisual());
	}

	/* (non-Javadoc)
	 * @see jp.ac.keio.sfc.crew.view.sgef.editparts.SEditPart#getModelChildren()
	 */
	public List getModelChildren() {
		if (rootModel != null) {
			List children = new ArrayList();
			children.add(rootModel);
			return children;
		}
		return null;
	}

	/* (non-Javadoc)
	 * @see jp.ac.keio.sfc.crew.view.sgef.editparts.SEditPart#createVisual()
	 */
	protected VisualComponent createVisual() {
		return rootLayer;
	}

	protected VisualComponent getContentPane() {
		return getLayer(LAYER_NODES);
	}

	/*****************************************
	 * for Model.
	 *****************************************/

	/**
	 * @param object
	 */
	public void setModel(Object model) {
		throw new UnsupportedOperationException("Cannot set model to RootEditPart. Use setRootModel() instead");
	}

	/*****************************************
	 * for RootModel.
	 *****************************************/

	/**
	 * @return
	 */
	public Object getRootModel() {
		return rootModel;
	}

	/**
	 * @param object
	 */
	public void setRootModel(Object rootModel) {
		this.rootModel = rootModel;
	}

	/*****************************************
	 * Getters for Layers.
	 *****************************************/

	/**
	 * Installs the Layer 
	 */
	public void installLayer(
		Object key,
		LayerVisualComponent layer,
		int index) {
		installLayer(key, rootLayer, layer, index);
	}

	/**
	 * Installs the Layer 
	 */
	public void installLayer(
		Object key,
		Object parentKey,
		LayerVisualComponent layer,
		int index) {
		installLayer(key, getLayer(parentKey), layer, index);
	}

	/**
	 * Installs the Layer 
	 */
	public void installLayer(
		Object key,
		LayerVisualComponent parentLayer,
		LayerVisualComponent layer,
		int index) {
		layerTable.put(key, layer);
		parentLayer.add(layer, index);
	}

	/**
	 * Gets the Layer by Key
	 */
	public LayerVisualComponent getLayer(Object key) {
		return (LayerVisualComponent) layerTable.get(key);
	}

	/**
	 * Gets the Layer by Key
	 */
	public void addVisualToLayer(VisualComponent visual, Object key) {
		LayerVisualComponent layer = getLayer(key);
		layer.add(visual);
		layer.validate();
		layer.repaint();
	}

	/**
	 * Gets the Layer by Key
	 */
	public void removeVisualFromLayer(VisualComponent visual, Object key) {
		LayerVisualComponent layer = getLayer(key);
		layer.remove(visual);
		layer.repaint();
	}

}
