/*
 * SPackageEditPartFactory.java
 * Created on 2003/10/17
 * 
 * Copyright (c) 2003 CreW Project. All rights reserved.
 */
package jp.ac.keio.sfc.crew.view.sgef.editparts;

import jp.ac.keio.sfc.crew.refrection.CClassUtil;

/**
 * Class SPackageEditPartFactory.
 * 
 * @author macchan
 * @version $Id: SPackageEditPartFactory.java,v 1.1 2003/12/11 10:26:58 macchan Exp $
 */
public class SPackageEditPartFactory implements SEditPartFactory {

	private String packageName;

	/**
	 * Constructor for SPackageEditPartFactory.
	 */
	public SPackageEditPartFactory(Package pack) {
		this.packageName = pack.getName();
	}

	/**
	 * Constructor for SPackageEditPartFactory.
	 */
	public SPackageEditPartFactory(String packageName) {
		this.packageName = packageName;
	}

	/**
	 * @see jp.ac.keio.sfc.crew.view.sgef.editparts.SEditPartFactory#createEditPart(java.lang.Object)
	 */
	public SEditPart createEditPart(Object model) {
		try {
			String fqcn =
				packageName
					+ "."
					+ CClassUtil.getSimpleClassName(model)
					+ "EditPart";
			SEditPart editpart = (SEditPart) Class.forName(fqcn).newInstance();
			return editpart;
		} catch (Exception ex) {
			throw new RuntimeException(
				"EditPart cannot found for model class = "
					+ model.getClass().getName());
		}
	}

}
