/*
 * EConnectionManager.java
 * Created on 2003/10/16
 * 
 * Copyright (c) 2003 CreW Project. All rights reserved.
 */
package jp.ac.keio.sfc.crew.view.sgef.ext;

import java.util.Iterator;
import java.util.List;

import jp.ac.keio.sfc.crew.collection.MultipleKeyMap;
import jp.ac.keio.sfc.crew.collection.MultipleValueMap;
import jp.ac.keio.sfc.crew.view.sgef.ext.editparts.EConnectionEditPart;
import jp.ac.keio.sfc.crew.view.sgef.ext.editparts.EGraphicalEditPart;

/**
 * Class EConnectionManager.
 * 
 * @author macchan
 * @version $Id: EConnectionManager.java,v 1.1 2003/12/11 10:27:05 macchan Exp $
 */
public class EConnectionManager {

	/******************************
	 * Instance Variables.
	 ******************************/

	private EGraphicalEditor editor;

	private MultipleKeyMap connectionsTable = new MultipleKeyMap();
	private MultipleValueMap notRegisterdTargetConnectionsTable =
		new MultipleValueMap();

	/******************************
	 * Constructors.
	 ******************************/

	/**
	 * Constructor for EConnectionManager.
	 */
	public EConnectionManager(EGraphicalEditor editor) {
		this.editor = editor;
	}

	/******************************
	 * Register Methods.
	 ******************************/

	public void registerEditPart(EGraphicalEditPart editpart) {
		if (editpart instanceof EConnectionEditPart) {
			registerConnectionEditPartImpl((EConnectionEditPart) editpart);
		} else {
			registerEditPartImpl(editpart);
		}
	}

	private void registerConnectionEditPartImpl(EConnectionEditPart connectionEditPart) {
		Object source = connectionEditPart.getModelSource();
		Object target = connectionEditPart.getModelTarget();

		//Adds target connection to target.		
		EGraphicalEditPart targetEditPart =
			(EGraphicalEditPart) editor.getEditPart(target);
		if (targetEditPart != null) {
			targetEditPart.addTemporaryAccessories(connectionEditPart);
		} else {
			//If target editpart not found, put as unregisterd connections. 
			notRegisterdTargetConnectionsTable.put(target, connectionEditPart);
		}

		//Register Connection
		if (!connectionsTable.containtsValue(connectionEditPart)) {
			connectionsTable.put(source, target, connectionEditPart);
			reorderConnections(connectionsTable.get(source, target));
		}
	}

	private void registerEditPartImpl(EGraphicalEditPart editpart) {
		//Adds unregisterd connecitons to target.
		if (notRegisterdTargetConnectionsTable
			.containtsKey(editpart.getModel())) {
			List targetConnections =
				notRegisterdTargetConnectionsTable.removeByKey(
					editpart.getModel());
			for (Iterator i = targetConnections.iterator(); i.hasNext();) {
				EConnectionEditPart connectionEditPart =
					(EConnectionEditPart) i.next();
				editpart.addTemporaryAccessories(connectionEditPart);
			}
		}
	}

	public void unregisterEditPart(EGraphicalEditPart editpart) {
		if (editpart instanceof EConnectionEditPart) {
			unregisterConnectionEditPartImpl((EConnectionEditPart) editpart);
		} else {
			unregisterEditPartImpl(editpart);
		}
	}

	public void unregisterConnectionEditPartImpl(EConnectionEditPart connectionEditPart) {
		Object source = connectionEditPart.getModelSource();
		Object target = connectionEditPart.getModelTarget();

		//Removes target connection from target.
		EGraphicalEditPart targetEditPart =
			(EGraphicalEditPart) editor.getEditPart(target);
		if (targetEditPart != null) {
			targetEditPart.removeTemporaryAccessories(connectionEditPart);
		}

		//UnRegister Connection
		if (connectionsTable.containtsValue(connectionEditPart)) {
			connectionsTable.removeByValue(connectionEditPart);
			reorderConnections(connectionsTable.get(source, target));
		}
	}

	public void unregisterEditPartImpl(EGraphicalEditPart editpart) {
		//do nothing
	}

	private void reorderConnections(List connections) {
		int size = connections.size();
		for (int i = 0; i < size; i++) {
			EConnectionEditPart editpart =
				(EConnectionEditPart) connections.get(i);
			editpart.setConstraints(i, size);
		}
	}

}
