/*
 * EGraphicalEditor.java
 * Created on 2003/10/16
 * 
 * Copyright (c) 2003 CreW Project. All rights reserved.
 */
package jp.ac.keio.sfc.crew.view.sgef.ext;

import jp.ac.keio.sfc.crew.view.sgef.SGraphicalEditor;
import jp.ac.keio.sfc.crew.view.sgef.editparts.SEditPart;
import jp.ac.keio.sfc.crew.view.sgef.ext.editparts.EGraphicalEditPart;

/**
 * Class EGraphicalEditor.
 * 
 * @author macchan
 * @version $Id: EGraphicalEditor.java,v 1.1 2003/12/11 10:27:05 macchan Exp $
 */
public class EGraphicalEditor extends SGraphicalEditor {

	private EConnectionManager connectionManager = new EConnectionManager(this);

	/**
	 * Constructor for EGraphicalEditor.
	 */
	public EGraphicalEditor() {
		super();
	}

	/***********************************
	 * Delegation to ElementManager
	 ***********************************/

	public void registerEditPart(SEditPart parent, SEditPart editpart) {
		super.registerEditPart(parent, editpart);
		if (editpart instanceof EGraphicalEditPart) {
			connectionManager.registerEditPart((EGraphicalEditPart) editpart);
		}
	}

	public void unregisterEditPart(SEditPart parent, SEditPart editpart) {
		super.unregisterEditPart(parent, editpart);
		if (editpart instanceof EGraphicalEditPart) {
			connectionManager.unregisterEditPart((EGraphicalEditPart) editpart);
		}
	}
}
