/*
 * EConnectionEditPart.java
 * Created on 2003/10/16
 * 
 * Copyright (c) 2003 CreW Project. All rights reserved.
 */
package jp.ac.keio.sfc.crew.view.sgef.ext.editparts;

import jp.ac.keio.sfc.crew.view.sgef.editparts.SEditPart;
import jp.ac.keio.sfc.crew.view.sgef.ext.visuals.EConnectionVisualComponent;

/**
 * Class EConnectionEditPart.
 * 
 * @author macchan
 * @version $Id: EConnectionEditPart.java,v 1.1 2003/12/11 10:26:50 macchan Exp $
 */
public abstract class EConnectionEditPart extends EGraphicalEditPart {

	private int index = -1;
	private int count = -1;

	/**
	 * Constructor for EConnectionEditPart.
	 */
	public EConnectionEditPart() {
		super();
	}

	protected void activate() {
		super.activate();
		getRoot().addVisualToLayer(getVisual(), getLayerConstants());
	}

	protected void deactivate() {
		getRoot().removeVisualFromLayer(getVisual(), getLayerConstants());
		super.deactivate();
	}

	public Object getLayerConstants() {
		return EGraphicalRootEditPart.LAYER_UPPER_CONNECTIONS;
	}

	public int getIndex() {
		return index;
	}

	public int getCount() {
		return count;
	}

	public void setConstraints(int index, int count) {
		if (this.index != index || this.count != count) {
			this.index = index;
			this.count = count;
			refreshVisualRecursively();
		}
	}

	public abstract Object getModelSource();
	public abstract Object getModelTarget();

	/* (non-Javadoc)
	 * @see jp.ac.keio.sfc.crew.view.sgef.editparts.SEditPart#refreshVisual()
	 */
	public void refreshVisual() {
		super.refreshVisual();

		EConnectionVisualComponent visual =
			(EConnectionVisualComponent) getVisual();

		SEditPart sourceEditPart = getEditor().getEditPart(getModelSource());
		if (sourceEditPart != null) {
			visual.setSource(sourceEditPart.getVisual());
		}

		SEditPart targetEditPart = getEditor().getEditPart(getModelTarget());
		if (targetEditPart != null) {
			visual.setTarget(targetEditPart.getVisual());
		}

		visual.setConstraints(index, count);

		visual.refreshVisual();
	}

}
