/*
 * EGraphicalEditPart.java
 * Created on 2003/10/16
 * 
 * Copyright (c) 2003 CreW Project. All rights reserved.
 */
package jp.ac.keio.sfc.crew.view.sgef.ext.editparts;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import jp.ac.keio.sfc.crew.view.sgef.editparts.SEditPart;
import jp.ac.keio.sfc.crew.view.sgef.editparts.SGraphicalEditPart;

/**
 * Class EGraphicalEditPart.
 * 
 * @author macchan
 * @version $Id: EGraphicalEditPart.java,v 1.1 2003/12/11 10:26:50 macchan Exp $
 */
public abstract class EGraphicalEditPart extends SGraphicalEditPart {

	private List temporaryAccessories = new ArrayList();
	private SEditPart handle;

	/**
	 * Constructor for EGraphicalEditPart.
	 */
	public EGraphicalEditPart() {
		super();
	}

	protected List getModelAccessories() {
		List accessories = new ArrayList();

		List models;
		models = getModelAttachments();
		if (models != null) {
			accessories.addAll(models);
		}

		models = getModelUpperConnections();
		if (models != null) {
			accessories.addAll(models);
		}

		models = getModelLowerConnections();
		if (models != null) {
			accessories.addAll(models);
		}

		return accessories;
	}

	protected List getModelUpperConnections() {
		return null;
	}

	protected List getModelLowerConnections() {
		return null;
	}

	protected List getModelAttachments() {
		return null;
	}

	public void refreshVisualRecursively() {
		refreshVisual();
		refreshChildrenVisual();
		refreshAccessoriesVisual();
		refreshTemporaryAccessoriesVisual();
	}

	public void refreshTemporaryAccessoriesVisual() {
		for (Iterator i = temporaryAccessories.iterator(); i.hasNext();) {
			SEditPart temporaryAccessory = (SEditPart) i.next();
			temporaryAccessory.refreshVisualRecursively();
		}
	}

	public void addTemporaryAccessories(SEditPart editpart) {
		this.temporaryAccessories.add(editpart);
	}

	public void removeTemporaryAccessories(SEditPart editpart) {
		this.temporaryAccessories.remove(editpart);
	}

	protected SEditPart getHandle() {
		if (handle == null) {
			handle = createHandle();
		}
		return handle;
	}

	protected SEditPart createHandle() {
		return new EHandleEditPart();
	}

	public void addHandle() {
		initializeEditPart(getHandle());
		addAttachment(getHandle());
		refreshVisualRecursively();
	}

	public void removeHandle() {
		removeAttachment(getHandle());
		terminateEditPart(getHandle());
		refreshVisualRecursively();
	}

}
