/*
 * EGraphicalRootEditPart.java
 * Created on 2003/10/16
 * 
 * Copyright (c) 2003 CreW Project. All rights reserved.
 */
package jp.ac.keio.sfc.crew.view.sgef.ext.editparts;

import jp.ac.keio.sfc.crew.swing.visuals.LayerVisualComponent;
import jp.ac.keio.sfc.crew.swing.visuals.LightWeightLayerVisualComponent;
import jp.ac.keio.sfc.crew.view.sgef.editparts.SGraphicalRootEditPart;

/**
 * Class EGraphicalRootEditPart.
 * 
 * @author macchan
 * @version $Id: EGraphicalRootEditPart.java,v 1.1 2003/12/11 10:26:50 macchan Exp $
 */
public class EGraphicalRootEditPart extends SGraphicalRootEditPart {

	/*****************************************
	 * Constants.
	 *****************************************/

	public static final Object LAYER_ATTACHMENTS = "ATTACHMENTS";
	public static final Object LAYER_HANDLES = "HANDLES";
	public static final Object LAYER_LOWER_CONNECTIONS = "LOWER_CONNECTIONS";
	public static final Object LAYER_UPPER_CONNECTIONS = "UPPER_CONNECTIONS";
	public static final Object LAYER_ANIMATION = "ANIMATION";

	/*****************************************
	 * Constructors.
	 *****************************************/

	/**
	 * Constructor for EGraphicalRootEditPart.
	 */
	public EGraphicalRootEditPart() {
	}

	protected void installLayers() {
		super.installLayers();
		installLayer(
			LAYER_LOWER_CONNECTIONS,
			new LightWeightLayerVisualComponent(),
			1);
		installLayer(LAYER_ATTACHMENTS, new LayerVisualComponent(), 0);
		installLayer(
			LAYER_UPPER_CONNECTIONS,
			new LightWeightLayerVisualComponent(),
			0);
		installLayer(LAYER_ANIMATION, new LayerVisualComponent(), 0);
		installLayer(LAYER_HANDLES, new LayerVisualComponent(), 0);
	}

}
