/*
 * EHandleEditPart.java
 * Created on 2003/10/17
 * 
 * Copyright (c) 2003 CreW Project. All rights reserved.
 */
package jp.ac.keio.sfc.crew.view.sgef.ext.editparts;

import java.awt.Color;
import java.awt.Rectangle;

import jp.ac.keio.sfc.crew.swing.visuals.RectangleVisualComponent;
import jp.ac.keio.sfc.crew.swing.visuals.VisualComponent;

/**
 * Class EHandleEditPart.
 * 
 * @author macchan
 * @version $Id: EHandleEditPart.java,v 1.1 2003/12/11 10:26:50 macchan Exp $
 */
public class EHandleEditPart extends EGraphicalEditPart {

	public static final int LINE_WIDTH = 4;

	/**
	 * Constructor for EHandleEditPart.
	 */
	public EHandleEditPart() {
		super();
	}

	protected void activate() {
		super.activate();
		getRoot().addVisualToLayer(
			getVisual(),
			EGraphicalRootEditPart.LAYER_HANDLES);
	}

	protected void deactivate() {
		getRoot().removeVisualFromLayer(
			getVisual(),
			EGraphicalRootEditPart.LAYER_HANDLES);
		super.deactivate();
	}

	protected VisualComponent createVisual() {
		RectangleVisualComponent handle = new RectangleVisualComponent();
		handle.setLineWidth(LINE_WIDTH);
		handle.setForeground(Color.BLACK);
		return handle;
	}

	public void refreshVisual() {
		VisualComponent parentVisual = getParent().getVisual();
		RectangleVisualComponent handle =
			(RectangleVisualComponent) getVisual();

		Rectangle bounds = parentVisual.getBounds();
		int insets = LINE_WIDTH / 2;
		bounds.x -= insets;
		bounds.y -= insets;
		bounds.width += LINE_WIDTH;
		bounds.height += LINE_WIDTH;
		handle.setBounds(bounds);

		handle.setLocationByCenter(parentVisual.getAbsoluteCenterLocation());
	}

}
