/*
 * EConnectionVisualComponent.java
 * Created on 2003/10/17
 * 
 * Copyright (c) 2003 CreW Project. All rights reserved.
 */
package jp.ac.keio.sfc.crew.view.sgef.ext.visuals;

import jp.ac.keio.sfc.crew.swing.visuals.LayerVisualComponent;
import jp.ac.keio.sfc.crew.swing.visuals.VisualComponent;

/**
 * Class EConnectionVisualComponent.
 * 
 * @author macchan
 * @version $Id: EConnectionVisualComponent.java,v 1.1 2003/12/11 10:26:57 macchan Exp $
 */
public abstract class EConnectionVisualComponent extends LayerVisualComponent {

	/***************************************
	 * Constants.
	 ***************************************/

	public static final VisualComponent DEFAULT_CONNECTION_ANCHOR =
		new VisualComponent();

	/***************************************
	 * Instance Variables.
	 ***************************************/

	private int index = 0;
	private int count = 1;

	private VisualComponent source = DEFAULT_CONNECTION_ANCHOR;
	private VisualComponent target = DEFAULT_CONNECTION_ANCHOR;

	/***************************************
	 * Constructors.
	 ***************************************/

	/**
	 * Constructor for EConnectionVisualComponent.
	 */
	public EConnectionVisualComponent() {
		super();
	}

	/***************************************
	 * Index and Count
	 ***************************************/

	public int getIndex() {
		return index;
	}

	public int getCount() {
		return count;
	}

	public void setConstraints(int index, int count) {
		if (this.index != index || this.count != count) {
			this.index = index;
			this.count = count;
		}
	}

	/***************************************
	 * Getters and Setters for source, and target
	 ***************************************/

	/**
	 * Method getSource.
	 * @return
	 */
	public VisualComponent getSource() {
		return source;
	}

	/**
	 * Method getTarget.
	 * @return
	 */
	public VisualComponent getTarget() {
		return target;
	}

	/**
	 * @param component
	 */
	public void setSource(VisualComponent source) {
		this.source = source;
	}

	/**
	 * @param component
	 */
	public void setTarget(VisualComponent target) {
		this.target = target;
	}

	/***************************************
	 * Refresh Visuals
	 ***************************************/

	public void refreshVisual() {
	}

}
