/*
 * SDragMoveTool.java
 * Created on 2003/10/12
 * 
 * Copyright (c) 2003 CreW Project. All rights reserved.
 */
package jp.ac.keio.sfc.crew.view.sgef.tools;

import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import javax.swing.JComponent;

import jp.ac.keio.sfc.crew.swing.SwingUtil;
import jp.ac.keio.sfc.crew.swing.visuals.RectangleVisualComponent;
import jp.ac.keio.sfc.crew.swing.visuals.VisualComponent;
import jp.ac.keio.sfc.crew.view.sgef.SGraphicalEditor;
import jp.ac.keio.sfc.crew.view.sgef.editparts.SEditPart;

/**
 * Class SDragMoveTool.
 * 
 * @author macchan
 * @version $Id: SDragMoveTool.java,v 1.1 2003/12/11 10:26:57 macchan Exp $
 */
public class SDragMoveTool
	extends SEditingTool
	implements MouseListener, MouseMotionListener {

	/************************************
	 * Instance Variables.
	 ************************************/

	private VisualComponent memento;
	private Point previousLocation;
	boolean isDragging = false;
	boolean isMoving = false;

	/************************************
	 * Constructors.
	 ************************************/

	/**
	 * Constructor for SDragMoveTool.
	 */
	public SDragMoveTool(SGraphicalEditor editor) {
		super(editor);
	}

	/************************************
	 * Active and Deactive
	 ************************************/

	protected void activate() {
		this.getEditor().getRootLayer().addMouseListener(this);
		this.getEditor().getRootLayer().addMouseMotionListener(this);
	}

	protected void deactivate() {
		this.getEditor().getRootLayer().removeMouseListener(this);
		this.getEditor().getRootLayer().removeMouseMotionListener(this);
	}

	/************************************
	 * Implements for MouseListener
	 ************************************/

	/* (non-Javadoc)
	 * @see java.awt.event.MouseListener#mouseClicked(java.awt.event.MouseEvent)
	 */
	public void mouseClicked(MouseEvent e) {
	}

	/* (non-Javadoc)
	 * @see java.awt.event.MouseListener#mouseEntered(java.awt.event.MouseEvent)
	 */
	public void mouseEntered(MouseEvent e) {
	}

	/* (non-Javadoc)
	 * @see java.awt.event.MouseListener#mouseExited(java.awt.event.MouseEvent)
	 */
	public void mouseExited(MouseEvent e) {
	}

	/* (non-Javadoc)
	 * @see java.awt.event.MouseListener#mousePressed(java.awt.event.MouseEvent)
	 */
	public void mousePressed(MouseEvent e) {
		this.setPreviousLocation(e.getPoint());
	}

	/* (non-Javadoc)
	 * @see java.awt.event.MouseListener#mouseReleased(java.awt.event.MouseEvent)
	 */
	public void mouseReleased(MouseEvent e) {
		if (isDragging()) {
			endDrag(e);
		}
	}

	/* (non-Javadoc)
	 * @see java.awt.event.MouseMotionListener#mouseDragged(java.awt.event.MouseEvent)
	 */
	public void mouseDragged(MouseEvent e) {
		if (!isDragging()) {
			startDrag(e);
		}
		if (isMoving()) {
			move(e);
		}
	}

	/* (non-Javadoc)
	 * @see java.awt.event.MouseMotionListener#mouseMoved(java.awt.event.MouseEvent)
	 */
	public void mouseMoved(MouseEvent e) {
	}

	/************************************
	 * Implements for MouseListener
	 ************************************/

	private void move(MouseEvent e) {
		int mx = e.getX() - (int) previousLocation.getX();
		int my = e.getY() - (int) previousLocation.getY();

		memento.moveLocation(mx, my);
		this.setPreviousLocation(e.getPoint());
	}

	private void startDrag(MouseEvent e) {
		setDragging(true);
		if (getEditor().hasSelectedEditPart()) {
			startMove();
		}
	}

	private void endDrag(MouseEvent e) {
		setDragging(false);
		if (isMoving()) {
			endMove();
		}
	}

	private void startMove() {
		setMoving(true);
		setMemento(createMemento());
		this.getEditor().getSelectionLayer().add(getMemento());
		this.getEditor().getSelectionLayer().validate();
	}

	private void endMove() {
		moveCompleted();
		this.getEditor().getSelectionLayer().remove(getMemento());
		this.getEditor().getSelectionLayer().repaint();
		setMoving(false);
	}

	private void moveCompleted() {
		synchronized (getEditor().getTreeLock()) {
			List editparts = this.getEditor().getSelectedEditParts();
			int size = editparts.size();
			for (int i = 0; i < size; i++) {
				SEditPart editpart = (SEditPart) editparts.get(i);
				VisualComponent aMemento =
					(VisualComponent) getMemento().getComponent(i);
				Point location = aMemento.getAbsoluteLocation();
				editpart.getVisual().setLocation(location);
				editpart.refreshVisualRecursively();
			}
			getEditor().repaint();
		}
	}

	/**
	 * @return
	 */
	public boolean isDragging() {
		return isDragging;
	}

	/**
	 * @param b
	 */
	public void setDragging(boolean b) {
		isDragging = b;
	}

	/**
	 * @return
	 */
	public Point getPreviousLocation() {
		return previousLocation;
	}

	/**
	 * @param point
	 */
	public void setPreviousLocation(Point point) {
		previousLocation = point;
	}

	/**
	 * @return
	 */
	public boolean isMoving() {
		return isMoving;
	}

	/**
	 * @param b
	 */
	public void setMoving(boolean b) {
		isMoving = b;
	}

	/**
	 * @return
	 */
	public VisualComponent getMemento() {
		return memento;
	}

	/**
	 * @param component
	 */
	public void setMemento(VisualComponent component) {
		memento = component;
	}

	protected VisualComponent createMemento() {

		List mementos = new ArrayList();
		List selectedParts = this.getEditor().getSelectedEditParts();
		Rectangle r = null;
		for (Iterator i = selectedParts.iterator(); i.hasNext();) {
			SEditPart editpart = (SEditPart) i.next();
			JComponent visual = editpart.getVisual();
			JComponent aMemento = createMementoVisual();
			aMemento.setBounds(visual.getBounds());
			mementos.add(aMemento);
			if (r == null) {
				r = aMemento.getBounds();
			} else {
				r = r.union(aMemento.getBounds());
			}
		}

		VisualComponent memento = new RectangleVisualComponent();
		memento.setBounds(r);
		for (Iterator i = mementos.iterator(); i.hasNext();) {
			VisualComponent aMemento = (VisualComponent) i.next();
			aMemento.moveLocation((int) - r.getX(), (int) - r.getY());
			memento.add(aMemento);
		}

		return memento;
	}

	protected VisualComponent createMementoVisual() {
		VisualComponent memento = new RectangleVisualComponent();
		memento.setForeground(SwingUtil.COLOR_OPAQUE);
		memento.setBackground(SwingUtil.createAlphaedColor(Color.blue, 75));
		return memento;
	}

}
