/*
 * SEditingTool.java
 * Created on 2003/10/12
 * 
 * Copyright (c) 2003 CreW Project. All rights reserved.
 */
package jp.ac.keio.sfc.crew.view.sgef.tools;

import jp.ac.keio.sfc.crew.view.sgef.SGraphicalEditor;

/**
 * Class SEditingTool.
 * 
 * @author macchan
 * @version $Id: SEditingTool.java,v 1.1 2003/12/11 10:26:57 macchan Exp $
 */
public abstract class SEditingTool {

	private boolean active;
	private SGraphicalEditor editor;

	/**
	 * Constructor for SEditingTool.
	 */
	public SEditingTool(SGraphicalEditor editor) {
		this.editor = editor;
	}

	/**
	 * @return
	 */
	public SGraphicalEditor getEditor() {
		return editor;
	}

	/**
	 * @return
	 */
	public boolean isActive() {
		return active;
	}

	/**
	 * @param active
	 */
	public void setActive(boolean active) {
		if (!this.active && active) {
			activate();
			this.active = true;
		} else if (this.active && !active) {
			deactivate();
			this.active = false;
		}
	}

	protected abstract void activate();

	protected abstract void deactivate();

}
