/*
 * SSelectionTool.java
 * Created on 2003/10/12
 * 
 * Copyright (c) 2003 CreW Project. All rights reserved.
 */
package jp.ac.keio.sfc.crew.view.sgef.tools;

import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

import jp.ac.keio.sfc.crew.swing.visuals.VisualComponent;
import jp.ac.keio.sfc.crew.view.sgef.SGraphicalEditor;
import jp.ac.keio.sfc.crew.view.sgef.editparts.SEditPart;

/**
 * Class SSelectionTool.
 * 
 * @author macchan
 * @version $Id: SSelectionTool.java,v 1.1 2003/12/11 10:26:57 macchan Exp $
 */
public class SSelectionTool extends SEditingTool implements MouseListener {

	private SEditPart selectedEditPart;

	/**
	 * Constructor for SSelectionTool.
	 */
	public SSelectionTool(SGraphicalEditor editor) {
		super(editor);
	}

	/* (non-Javadoc)
	 * @see jp.ac.keio.sfc.crew.view.sgef.tools.SEditingTool#activate()
	 */
	protected void activate() {
		getEditor().getRootLayer().addMouseListener(this);
	}

	/* (non-Javadoc)
	 * @see jp.ac.keio.sfc.crew.view.sgef.tools.SEditingTool#deactivate()
	 */
	protected void deactivate() {
		getEditor().getRootLayer().removeMouseListener(this);
	}

	/* (non-Javadoc)
	 * @see java.awt.event.MouseListener#mouseClicked(java.awt.event.MouseEvent)
	 */
	public void mouseClicked(MouseEvent e) {
		unselection(e);
	}

	/* (non-Javadoc)
	 * @see java.awt.event.MouseListener#mouseEntered(java.awt.event.MouseEvent)
	 */
	public void mouseEntered(MouseEvent e) {
	}

	/* (non-Javadoc)
	 * @see java.awt.event.MouseListener#mouseExited(java.awt.event.MouseEvent)
	 */
	public void mouseExited(MouseEvent e) {
	}

	/* (non-Javadoc)
	 * @see java.awt.event.MouseListener#mousePressed(java.awt.event.MouseEvent)
	 */
	public void mousePressed(MouseEvent e) {
		selection(e);
	}

	/* (non-Javadoc)
	 * @see java.awt.event.MouseListener#mouseReleased(java.awt.event.MouseEvent)
	 */
	public void mouseReleased(MouseEvent e) {
	}

	private void selection(MouseEvent e) {
		//Find the editpart
		VisualComponent selectedVisual =
			getDeepestSelectableComponent(
				this.getEditor().getContentsLayer(),
				e.getX(),
				e.getY());

		selectedEditPart = getEditor().getEditPart(selectedVisual);

		if (!getEditor().getSelectedEditParts().contains(selectedEditPart)) {
			//If special key not pressed, clear all selection. 
			if (!(e.isControlDown() || e.isShiftDown())) {
				getEditor().clearSelection();
			}
		}

		//Select the editpart.
		if (selectedEditPart != null) {
			getEditor().addSelectedEditPart(selectedEditPart);
		}
	}

	private void unselection(MouseEvent e) {
		//If special key not pressed, clear all selection. 
		if (!(e.isControlDown() || e.isShiftDown())) {
			getEditor().clearSelection();
		}

		//Select the editpart.
		if (selectedEditPart != null) {
			getEditor().addSelectedEditPart(selectedEditPart);
		}
	}

	private VisualComponent getDeepestSelectableComponent(
		Component parent,
		int x,
		int y) {

		if (!parent.contains(x, y)) {
			return null;
		}

		if (parent instanceof Container) {
			Component components[] = ((Container) parent).getComponents();
			for (int i = 0; i < components.length; i++) {
				Component child = components[i];
				if (child != null && child.isVisible()) {
					Point loc = child.getLocation();
					if (child instanceof Container) {
						child =
							getDeepestSelectableComponent(
								child,
								x - loc.x,
								y - loc.y);
					} else {
						child = child.getComponentAt(x - loc.x, y - loc.y);
					}
					if (child != null
						&& child.isVisible()
						&& isSelectable(child)) {
						return (VisualComponent) child;
					}
				}
			}
		}

		if (parent instanceof VisualComponent) {
			if (parent.isVisible() && isSelectable(parent)) {
				return (VisualComponent) parent;
			}
		}
		return null;
	}

	private boolean isSelectable(Component component) {
		if (component instanceof VisualComponent) {
			VisualComponent visual = (VisualComponent) component;
			SEditPart editpart = getEditor().getEditPart(visual);
			if (editpart != null && editpart.isSelectable()) {
				return true;
			}
		}
		return false;
	}

}
