/*
 * CommunicationViewer.java
 * Created on 2003/10/18
 * 
 * Copyright (c) 2003 CreW Project. All rights reserved.
 */
package org.boxed_economy.components.commviewer;

import jp.ac.keio.sfc.crew.view.sgef.animation.CoverBlinkingAnimationThread;
import jp.ac.keio.sfc.crew.view.sgef.animation.MovingAnimationThread;
import jp.ac.keio.sfc.crew.view.sgef.animation.MovingAnimationThreadWithLine;
import jp.ac.keio.sfc.crew.view.sgef.animation.ShapeBlinkingAnimationThread;
import jp.ac.keio.sfc.crew.view.sgef.editparts.SGraphicalRootEditPart;
import jp.ac.keio.sfc.crew.view.sgef.ext.EGraphicalEditor;
import jp.ac.keio.sfc.crew.view.sgef.tools.SDragMoveTool;
import jp.ac.keio.sfc.crew.view.sgef.tools.SSelectionTool;

import org.boxed_economy.besp.model.fmfw.World;
import org
	.boxed_economy
	.components
	.commviewer
	.editparts
	.CommViewerEditPartFactory;
import org
	.boxed_economy
	.components
	.commviewer
	.editparts
	.CommunicationViewerRootEditPart;

/**
 * Class CommunicationViewer.
 * 
 * @author macchan
 * @version $Id: CommunicationViewer.java,v 1.1 2003/12/11 10:26:52 macchan Exp $
 */
public class CommunicationViewer {

	private EGraphicalEditor editor;
	private SGraphicalRootEditPart rootEditPart;

	private boolean animationEnable = true;

	private MovingAnimationThread goodsSendingThread =
		new MovingAnimationThread();
	private MovingAnimationThreadWithLine channelThread =
		new MovingAnimationThreadWithLine();
	private MovingAnimationThreadWithLine relationThread =
		new MovingAnimationThreadWithLine();
	private ShapeBlinkingAnimationThread blinkingThread =
		new ShapeBlinkingAnimationThread();
	private CoverBlinkingAnimationThread stateThread =
		new CoverBlinkingAnimationThread();
	private CoverBlinkingAnimationThread clockThread =
		new CoverBlinkingAnimationThread();

	/**
	 * Constructor for CommunicationViewer.
	 */
	public CommunicationViewer() {
		super();
		initializeThread();
	}

	public EGraphicalEditor getEditor() {
		if (editor == null) {
			editor = createEditor();
		}
		return editor;
	}

	/**
	 * Method createEditor.
	 * @return
	 */
	private EGraphicalEditor createEditor() {
		//GfB^
		EGraphicalEditor editor = new EGraphicalEditor();
		editor.setEditPartFactory(
			new CommViewerEditPartFactory("org.boxed_economy.components.commviewer.editparts"));

		//[g
		rootEditPart = new CommunicationViewerRootEditPart();
		editor.setRootEditPart(rootEditPart);

		//c[̐ݒ
		SSelectionTool selectiontool = new SSelectionTool(editor);
		selectiontool.setActive(true);
		SDragMoveTool movetool = new SDragMoveTool(editor);
		movetool.setActive(true);

		return editor;
	}

	protected void initializeThread() {

		goodsSendingThread.setInterval(20);
		goodsSendingThread.setStepCount(100);
		//movingThread.setLoop(true);

		channelThread.setInterval(20);
		channelThread.setStepCount(20);
		//movingLineThread.setLoop(true);

		relationThread.setInterval(20);
		relationThread.setStepCount(20);
		//movingLineThread.setLoop(true);

		blinkingThread.setInterval(500);

		stateThread.setStepCount(3);
		stateThread.setInterval(500);

		clockThread.setStepCount(3);
		clockThread.setInterval(500);
	}

	public void setWorld(World world) {
		rootEditPart.setRootModel(world);
		rootEditPart.refresh();
		editor.validate();
	}

	public void stopAllThread() {
		blinkingThread.stopAndWait();
		goodsSendingThread.stopAndWait();
		channelThread.stopAndWait();
		stateThread.stopAndWait();
		clockThread.stopAndWait();
	}

	/**
	 * Method getBlinkingThread.
	 * @return
	 */
	public ShapeBlinkingAnimationThread getBlinkingThread() {
		return blinkingThread;
	}

	/**
	 * Method getMovingLineThread.
	 * @return
	 */
	public MovingAnimationThreadWithLine getChannelThread() {
		return channelThread;
	}

	/**
	 * Method getMovingThread.
	 * @return
	 */
	public MovingAnimationThread getGoodsSendingThread() {
		return goodsSendingThread;
	}

	/**
	 * Method getCoverBlinkingThread.
	 * @return
	 */
	public CoverBlinkingAnimationThread getStateThread() {
		return stateThread;
	}

	/**
	 * Method getRelationThread.
	 * @return
	 */
	public MovingAnimationThreadWithLine getRelationThread() {
		return relationThread;
	}

	/**
	 * Method setRelationThread.
	 * @param line
	 */
	public void setRelationThread(MovingAnimationThreadWithLine line) {
		relationThread = line;
	}

	/**
	 * Method getClockThread.
	 * @return
	 */
	public CoverBlinkingAnimationThread getClockThread() {
		return clockThread;
	}

	/**
	 * Method isAnimationEnable.
	 * @return
	 */
	public boolean isAnimationEnable() {
		return animationEnable;
	}

	/**
	 * Method setAnimationEnable.
	 * @param b
	 */
	public void setAnimationEnable(boolean enable) {
		animationEnable = enable;
		if (animationEnable && !enable) {
			stopAllThread();
		}
	}

}
