/*
 * CommunicationViewerPlugin.java
 * Copyright (c) 2002 Boxed-Economy Project.  All rights reserved.
 */
package org.boxed_economy.components.commviewer;

import java.util.ResourceBundle;

import org.boxed_economy.besp.container.BESPContainer;
import org.boxed_economy.besp.container.BESPPlugin;
import org.boxed_economy.besp.presentation.guifw.CreateComponentAction;
import org.boxed_economy.besp.presentation.guifw.GUIContainer;

/**
 * @author N.Aoyama
 * @version $Id: CommunicationViewerPlugin.java,v 1.2 2004/03/21 12:08:03 macchan Exp $
 */
public class CommunicationViewerPlugin implements BESPPlugin {

	/*****************************************
	 * \[X֘A
	 *****************************************/

	public static ResourceBundle resource =
		ResourceBundle.getBundle(CommunicationViewerResource.class.getName());

	public static void initializePlugin(BESPContainer container) {
		CreateComponentAction openCommViewerAction =
			new CreateComponentAction(
				resource.getString("Name_Component"),
				CommunicationViewerFrame.class);
		((GUIContainer) container
			.getPresentationContainer()
			.getPresentationComponent(GUIContainer.class))
			.showGeneralGroup
			.add(openCommViewerAction);
	}
}
