/*
 * AbstractCommunicationViewerSettingPanel.java
 * Created on 2003/10/25
 * 
 * Copyright (c) 2003 CreW Project. All rights reserved.
 */
package org.boxed_economy.components.commviewer.controller;

import java.util.ResourceBundle;

import javax.swing.JPanel;

import org.boxed_economy.components.commviewer.CommunicationViewer;
import org.boxed_economy.components.commviewer.CommunicationViewerResource;

/**
 * Class AbstractCommunicationViewerSettingPanel.
 * 
 * @author macchan
 * @version $Id: AbstractCommunicationViewerSettingPanel.java,v 1.1 2003/12/11 10:27:04 macchan Exp $
 */
public abstract class AbstractCommunicationViewerSettingPanel extends JPanel {

	public static ResourceBundle resource =
		ResourceBundle.getBundle(CommunicationViewerResource.class.getName());

	private CommunicationViewer viewer;

	/**
	 * Constructor for AbstractCommunicationViewerSettingPanel.
	 */
	public AbstractCommunicationViewerSettingPanel(CommunicationViewer viewer) {
		this.viewer = viewer;
		initializeComponent();
		initializeChildComponents();
	}

	/**
	 * Method initialize.
	 */
	protected abstract void initializeComponent();

	/**
	 * Method initializeChildren.
	 */
	protected abstract void initializeChildComponents();

	/**
	 * Method getViewer.
	 * @return
	 */
	public CommunicationViewer getViewer() {
		return viewer;
	}

}
