/*
 * AnimationSettingPanel.java
 * Created on 2003/10/25
 * 
 * Copyright (c) 2003 CreW Project. All rights reserved.
 */
package org.boxed_economy.components.commviewer.controller;

import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Dictionary;
import java.util.Hashtable;

import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

import jp.ac.keio.sfc.crew.swing.layout.VerticalFlowLayout;
import jp.ac.keio.sfc.crew.view.sgef.animation.AbstractAnimationThread;

import org.boxed_economy.components.commviewer.CommunicationViewer;

/**
 * Class AnimationSettingPanel.
 * 
 * @author macchan
 * @version $Id: AnimationSettingPanel.java,v 1.1 2003/12/11 10:27:04 macchan Exp $
 */
public class AnimationSettingPanel
	extends AbstractCommunicationViewerSettingPanel {

	private AbstractAnimationThread thread;

	private JCheckBox cEnableCheckBox;
	private JCheckBox cLoopCheckBox;
	private JSlider cSmoothSlider;
	private JSlider cIntervalSlider;

	/**
	 * Constructor for AnimationSettingPanel.
	 */
	public AnimationSettingPanel(
		CommunicationViewer viewer,
		AbstractAnimationThread thread) {
		super(viewer);
		setThread(thread);
	}

	/**
	 * @see org.boxed_economy.components.commviewer.controller.AbstractCommunicationViewerSettingPanel#initializeComponent()
	 */
	protected void initializeComponent() {
		setLayout(new VerticalFlowLayout());
	}

	/**
	 * @see org.boxed_economy.components.commviewer.controller.AbstractCommunicationViewerSettingPanel#initializeChildComponents()
	 */
	protected void initializeChildComponents() {
		cEnableCheckBox =
			new JCheckBox(resource.getString("control_animation_enable"));
		add(cEnableCheckBox);
		cEnableCheckBox.addItemListener(new ItemListener() {
			public void itemStateChanged(ItemEvent e) {
				thread.setEnable(cEnableCheckBox.isSelected());
			}
		});

		cLoopCheckBox =
			new JCheckBox(resource.getString("control_animation_loop"));
		add(cLoopCheckBox);
		cLoopCheckBox.addItemListener(new ItemListener() {
			public void itemStateChanged(ItemEvent e) {
				thread.setLoop(cLoopCheckBox.isSelected());
			}
		});

		JLabel smoothLabel = createSmoothLabel();
		add(smoothLabel);
		cSmoothSlider = createSmoothSlider();
		add(cSmoothSlider);
		cSmoothSlider.addChangeListener(new ChangeListener() {
			public void stateChanged(ChangeEvent e) {
				thread.setStepCount(cSmoothSlider.getValue());
			}
		});

		JLabel intervalLabel = createIntervalLabel();
		add(intervalLabel);
		cIntervalSlider = createIntervalSlider();
		add(cIntervalSlider);
		cIntervalSlider.addChangeListener(new ChangeListener() {
			public void stateChanged(ChangeEvent e) {
				thread.setInterval(cIntervalSlider.getValue());
			}
		});
	}

	protected JLabel createSmoothLabel() {
		return new JLabel(resource.getString("control_animation_smooth"));
	}

	protected JSlider createSlider() {
		JSlider slider = new JSlider();
		slider.setPreferredSize(new Dimension(120, 45));
		slider.setSnapToTicks(true);
		slider.setPaintLabels(true);
		slider.setPaintTicks(true);
		slider.setPaintTrack(true);
		slider.setLabelTable(createLabelTable(0, 100));
		return slider;
	}

	protected Dictionary createLabelTable(int min, int max) {
		Dictionary labels = new Hashtable();
		labels.put(new Integer(min), new JLabel(Integer.toString(min)));
		labels.put(new Integer(max), new JLabel(Integer.toString(max)));
		return labels;
	}

	protected JSlider createSmoothSlider() {
		JSlider slider = createSlider();

		//slider.setMinimum(0);
		//slider.setMaximum(5);
		//slider.setInverted(true);

		return slider;
	}

	protected JLabel createIntervalLabel() {
		return new JLabel(resource.getString("control_animation_interval"));
	}

	protected JSlider createIntervalSlider() {
		JSlider slider = createSlider();

		slider.setMinimum(1);
		//slider.setMaximum(500);
		//slider.setInverted(true);

		slider.setLabelTable(createLabelTable(1, 100));

		return slider;
	}

	/**
	 * Method getThread.
	 * @return
	 */
	public AbstractAnimationThread getThread() {
		return thread;
	}

	/**
	 * Method setThread.
	 * @param thread
	 */
	public void setThread(AbstractAnimationThread thread) {
		this.thread = thread;
		cEnableCheckBox.setSelected(thread.isEnable());
		cLoopCheckBox.setSelected(thread.isLoop());
		cSmoothSlider.setValue(thread.getStepCount());
		cIntervalSlider.setValue(thread.getInterval());
	}

}
