/*
 * BlinkingAnimationSettingPanel.java
 * Created on 2003/10/25
 * 
 * Copyright (c) 2003 CreW Project. All rights reserved.
 */
package org.boxed_economy.components.commviewer.controller;

import javax.swing.JLabel;
import javax.swing.JSlider;

import jp.ac.keio.sfc.crew.view.sgef.animation.AbstractAnimationThread;

import org.boxed_economy.components.commviewer.CommunicationViewer;

/**
 * Class BlinkingAnimationSettingPanel.
 * 
 * @author macchan
 * @version $Id: BlinkingAnimationSettingPanel.java,v 1.1 2003/12/11 10:27:04 macchan Exp $
 */
public class BlinkingAnimationSettingPanel extends AnimationSettingPanel {

	/**
	 * Constructor for BlinkingAnimationSettingPanel.
	 */
	public BlinkingAnimationSettingPanel(
		CommunicationViewer viewer,
		AbstractAnimationThread thread) {
		super(viewer, thread);
	}

	protected JLabel createSmoothLabel() {
		return new JLabel(resource.getString("control_animation_blink_count"));
	}

	protected JSlider createSmoothSlider() {
		JSlider slider = createSlider();

		//slider.setMinimum(0);
		slider.setMaximum(10);
		//slider.setInverted(true);

		slider.setLabelTable(createLabelTable(0, 10));

		return slider;
	}

	protected JLabel createIntervalLabel() {
		return new JLabel(resource.getString("control_animation_interval"));
	}

	protected JSlider createIntervalSlider() {
		JSlider slider = createSlider();

		slider.setMinimum(1);
		slider.setMaximum(500);
		//slider.setInverted(true);

		slider.setLabelTable(createLabelTable(1, 500));
		return slider;
	}

}
