/*
 * MainAnimationSettingPanel.java
 * Created on 2003/10/25
 * 
 * Copyright (c) 2003 CreW Project. All rights reserved.
 */
package org.boxed_economy.components.commviewer.controller;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;

import jp.ac.keio.sfc.crew.swing.layout.VerticalFlowLayout;

import org.boxed_economy.components.commviewer.CommunicationViewer;

/**
 * Class MainAnimationSettingPanel.
 * 
 * @author macchan
 * @version $Id: MainAnimationSettingPanel.java,v 1.1 2003/12/11 10:27:04 macchan Exp $
 */
public class MainAnimationSettingPanel
	extends AbstractCommunicationViewerSettingPanel {

	private JButton cButtonSkip;
	private JCheckBox cEnableAnimationCheckBox;

	/**
	 * Constructor for MainDisplaySettingPanel.
	 */
	public MainAnimationSettingPanel(CommunicationViewer viewer) {
		super(viewer);
	}

	protected void initializeComponent() {
		setLayout(new VerticalFlowLayout());
	}

	protected void initializeChildComponents() {

		cButtonSkip = new JButton(resource.getString("control_animation_skip"));
		add(cButtonSkip);
		cButtonSkip.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				getViewer().stopAllThread();
			}
		});

		cEnableAnimationCheckBox =
			new JCheckBox(
				resource.getString("control_animation_all_enable"),
				true);
		add(cEnableAnimationCheckBox);
		cEnableAnimationCheckBox.addItemListener(new ItemListener() {
			public void itemStateChanged(ItemEvent e) {
				getViewer().setAnimationEnable(
					cEnableAnimationCheckBox.isSelected());
			}
		});

		AnimationSettingPanel goodsSendingPanel =
			new AnimationSettingPanel(
				getViewer(),
				getViewer().getGoodsSendingThread());
		goodsSendingPanel.setBorder(
			BorderFactory.createTitledBorder(
				resource.getString("control_animation_goods_sending")));
		add(goodsSendingPanel);

		AnimationSettingPanel channelPanel =
			new AnimationSettingPanel(
				getViewer(),
				getViewer().getChannelThread());
		channelPanel.setBorder(
			BorderFactory.createTitledBorder(
				resource.getString("control_animation_channel")));
		add(channelPanel);

		AnimationSettingPanel relationPanel =
			new AnimationSettingPanel(
				getViewer(),
				getViewer().getRelationThread());
		relationPanel.setBorder(
			BorderFactory.createTitledBorder(
				resource.getString("control_animation_relation")));
		add(relationPanel);

		AnimationSettingPanel statePanel =
			new BlinkingAnimationSettingPanel(
				getViewer(),
				getViewer().getStateThread());
		statePanel.setBorder(
			BorderFactory.createTitledBorder(
				resource.getString("control_animation_state")));
		add(statePanel);

		AnimationSettingPanel clockPanel =
			new BlinkingAnimationSettingPanel(
				getViewer(),
				getViewer().getClockThread());
		clockPanel.setBorder(
			BorderFactory.createTitledBorder(
				resource.getString("control_animation_clock")));
		add(clockPanel);
	}

}
