/*
 * MainDisplaySettingPanel.java
 * Created on 2003/10/25
 * 
 * Copyright (c) 2003 CreW Project. All rights reserved.
 */
package org.boxed_economy.components.commviewer.controller;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

import javax.swing.JCheckBox;

import jp.ac.keio.sfc.crew.swing.layout.VerticalFlowLayout;

import org.boxed_economy.components.commviewer.CommunicationViewer;
import org
	.boxed_economy
	.components
	.commviewer
	.editparts
	.CommunicationViewerRootEditPart;

/**
 * Class MainDisplaySettingPanel.
 * 
 * @author macchan
 * @version $Id: MainDisplaySettingPanel.java,v 1.1 2003/12/11 10:27:04 macchan Exp $
 */
public class MainDisplaySettingPanel
	extends AbstractCommunicationViewerSettingPanel {

	private JCheckBox cAgentLabelCheckBox;
	private JCheckBox cRelationCheckBox;
	private JCheckBox cRelationLabelCheckBox;
	private JCheckBox cBehaviorCheckBox;
	private JCheckBox cStateCheckBox;

	/**
	 * Constructor for MainDisplaySettingPanel.
	 */
	public MainDisplaySettingPanel(CommunicationViewer viewer) {
		super(viewer);
	}

	protected void initializeComponent() {
		setLayout(new VerticalFlowLayout());
	}

	protected void initializeChildComponents() {
		cAgentLabelCheckBox =
			new JCheckBox(
				resource.getString("control_display_agent_label"),
				true);
		add(cAgentLabelCheckBox);
		cAgentLabelCheckBox.addItemListener(new ItemListener() {
			public void itemStateChanged(ItemEvent e) {
				updateAgentLabelDisplayMode();
			}
		});

		cRelationCheckBox =
			new JCheckBox(resource.getString("control_display_relation"), true);
		add(cRelationCheckBox);
		cRelationCheckBox.addItemListener(new ItemListener() {
			public void itemStateChanged(ItemEvent e) {
				updateRelationDisplayMode();
			}
		});

		cRelationLabelCheckBox =
			new JCheckBox(
				resource.getString("control_display_relation_label"),
				true);
		add(cRelationLabelCheckBox);
		cRelationLabelCheckBox.addItemListener(new ItemListener() {
			public void itemStateChanged(ItemEvent e) {
				updateRelationLabelDisplayMode();
			}
		});

		cBehaviorCheckBox =
			new JCheckBox(resource.getString("control_display_behavior"), true);
		add(cBehaviorCheckBox);
		cBehaviorCheckBox.addItemListener(new ItemListener() {
			public void itemStateChanged(ItemEvent e) {
				updateBehaviorDisplayMode();
			}
		});

		cStateCheckBox =
			new JCheckBox(resource.getString("control_display_state"), true);
		add(cStateCheckBox);
		cStateCheckBox.addItemListener(new ItemListener() {
			public void itemStateChanged(ItemEvent e) {
				updateStateDisplayMode();
			}
		});
	}

	protected void updateAgentLabelDisplayMode() {
		updateDisplayMode(
			CommunicationViewerRootEditPart.LAYER_AGENT_LABELS,
			cAgentLabelCheckBox);
	}

	protected void updateRelationDisplayMode() {
		updateDisplayMode(
			CommunicationViewerRootEditPart.LAYER_LOWER_CONNECTIONS,
			cRelationCheckBox);
	}

	protected void updateRelationLabelDisplayMode() {
		updateDisplayMode(
			CommunicationViewerRootEditPart.LAYER_RELATION_LABELS,
			cRelationLabelCheckBox);
	}

	protected void updateBehaviorDisplayMode() {
		updateDisplayMode(
			CommunicationViewerRootEditPart.LAYER_UPPER_CONNECTIONS,
			cBehaviorCheckBox);
		updateDisplayMode(
			CommunicationViewerRootEditPart.LAYER_BEHAVIOR_CONTAINERS,
			cBehaviorCheckBox);
	}

	protected void updateStateDisplayMode() {
		getRoot().setAllBehaviorStateVisible(cStateCheckBox.isSelected());
	}

	private void updateDisplayMode(Object layerConstants, JCheckBox checkbox) {
		synchronized (getViewer().getEditor().getTreeLock()) {
			getRoot().getLayer(layerConstants).setVisible(
				checkbox.isSelected());
		}
	}

	private CommunicationViewerRootEditPart getRoot() {
		return (CommunicationViewerRootEditPart) getViewer()
			.getEditor()
			.getRootEditPart();
	}

}
