/*
 * MainSettingPanel.java
 * Created on 2003/10/19
 * 
 * Copyright (c) 2003 CreW Project. All rights reserved.
 */
package org.boxed_economy.components.commviewer.controller;

import javax.swing.BorderFactory;

import jp.ac.keio.sfc.crew.swing.layout.VerticalFlowLayout;

import org.boxed_economy.components.commviewer.CommunicationViewer;

/**
 * Class MainSettingPanel.
 * 
 * @author macchan
 * @version $Id: MainSettingPanel.java,v 1.1 2003/12/11 10:27:04 macchan Exp $
 */
public class MainSettingPanel extends AbstractCommunicationViewerSettingPanel {

	private MainDisplaySettingPanel pDisplaySettingPanel;
	private MainAnimationSettingPanel pAnimationSettingPanel;

	/**
	 * Constructor for MainSettingPanel.
	 */
	public MainSettingPanel(CommunicationViewer viewer) {
		super(viewer);
	}

	protected void initializeComponent() {
		setLayout(new VerticalFlowLayout(VerticalFlowLayout.FILL));
	}

	protected void initializeChildComponents() {
		pDisplaySettingPanel = new MainDisplaySettingPanel(getViewer());
		pDisplaySettingPanel.setBorder(
			BorderFactory.createTitledBorder(
				resource.getString("control_display_title")));
		add(pDisplaySettingPanel);

		pAnimationSettingPanel = new MainAnimationSettingPanel(getViewer());
		pAnimationSettingPanel.setBorder(
			BorderFactory.createTitledBorder(
				resource.getString("control_animation_title")));
		add(pAnimationSettingPanel);
	}

}
