/*
 * AgentEditPart.java
 * Created on 2003/10/12
 * 
 * Copyright (c) 2003 CreW Project. All rights reserved.
 */
package org.boxed_economy.components.commviewer.editparts;

import java.awt.Image;
import java.util.ArrayList;
import java.util.List;

import jp.ac.keio.sfc.crew.swing.ImageProvider;
import jp.ac.keio.sfc.crew.swing.visuals.ImageVisualComponent;
import jp.ac.keio.sfc.crew.swing.visuals.VisualComponent;
import jp.ac.keio.sfc.crew.view.sgef.ext.editparts.EGraphicalEditPart;

import org.boxed_economy.besp.model.fmfw.Agent;
import org.boxed_economy.components.commviewer.model.AgentName;
import org.boxed_economy.components.commviewer.model.BehaviorManager;

/**
 * Class AgentEditPart.
 * 
 * @author macchan
 * @version $Id: AgentEditPart.java,v 1.1 2003/12/11 10:26:51 macchan Exp $
 */
public class AgentEditPart extends EGraphicalEditPart {

	private AgentName agentName;
	private BehaviorManager behaviorManager;

	/**
	 * Constructor for AgentEditPart.
	 */
	public AgentEditPart() {
		super();
	}

	protected Agent getAgent() {
		return (Agent) this.getModel();
	}

	protected void initialize() {
		agentName = new AgentName(getAgent());
		behaviorManager = new BehaviorManager(getAgent());
	}

	public boolean isSelectable() {
		return true;
	}

	protected VisualComponent createVisual() {
		ImageVisualComponent visual = new ImageVisualComponent();
		Image image =
			ImageProvider.getInstance().getImage(
				"org/boxed_economy/components/commviewer/visuals/agent.gif");
		visual.setImage(image);
		return visual;
	}

	protected List getModelAttachments() {
		List attachments = new ArrayList();
		attachments.add(behaviorManager);
		attachments.add(agentName);
		return attachments;
	}

	protected List getModelLowerConnections() {
		return getAgent().getAllRelations();
	}
}
