/*
 * AgentNameEditPart.java
 * Created on 2003/10/17
 * 
 * Copyright (c) 2003 CreW Project. All rights reserved.
 */
package org.boxed_economy.components.commviewer.editparts;

import java.awt.Font;
import java.awt.Point;

import javax.swing.JLabel;

import jp.ac.keio.sfc.crew.swing.visuals.PanelVisualComponent;
import jp.ac.keio.sfc.crew.swing.visuals.VisualComponent;
import jp.ac.keio.sfc.crew.view.sgef.ext.editparts.EAttachmentEditPart;

import org.boxed_economy.components.commviewer.model.AgentName;

/**
 * Class AgentNameEditPart.
 * 
 * @author macchan
 * @version $Id: AgentNameEditPart.java,v 1.1 2003/12/11 10:26:51 macchan Exp $
 */
public class AgentNameEditPart extends EAttachmentEditPart {

	public static final Font FONT = new Font("MS Gothic", Font.PLAIN, 18);

	private PanelVisualComponent panel = new PanelVisualComponent();
	private JLabel label = new JLabel();

	/**
	 * Constructor for AgentNameEditPart.
	 */
	public AgentNameEditPart() {
		super();
	}

	/**
	 * @see jp.ac.keio.sfc.crew.view.sgef.ext.editparts.EAttachmentEditPart#getLayer()
	 */
	protected Object getLayer() {
		return CommunicationViewerRootEditPart.LAYER_AGENT_LABELS;
	}

	protected AgentName getAgentName() {
		return (AgentName) this.getModel();
	}

	protected VisualComponent createVisual() {
		label.setFont(FONT);
		panel.add(label);
		panel.setOpaque(false);
		return panel;
	}

	public void refreshVisual() {
		//Sets Text
		label.setText(getAgentName().getName());

		//Sets Size
		getVisual().setSize(getVisual().getPreferredSize());

		//Sets Location
		Point loc = getParent().getVisual().getLocation();
		getVisual().setLocation(loc.x, loc.y - getVisual().getHeight() + 5);
	}

}
