/*
 * BehaviorEditPart.java
 * Created on 2003/10/13
 * 
 * Copyright (c) 2003 CreW Project. All rights reserved.
 */
package org.boxed_economy.components.commviewer.editparts;

import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Font;
import java.util.List;

import javax.swing.BorderFactory;
import javax.swing.JLabel;

import jp.ac.keio.sfc.crew.refrection.CClassUtil;
import jp.ac.keio.sfc.crew.swing.layout.VerticalFlowLayout;
import jp.ac.keio.sfc.crew.swing.visuals.PanelVisualComponent;
import jp.ac.keio.sfc.crew.swing.visuals.RoundRectVisualComponent;
import jp.ac.keio.sfc.crew.swing.visuals.VisualComponent;
import jp.ac.keio.sfc.crew.view.sgef.ext.editparts.EGraphicalEditPart;

import org.boxed_economy.besp.model.fmfw.Behavior;
import org.boxed_economy.besp.model.fmfw.behavior.State;

/**
 * Class BehaviorEditPart.
 * 
 * @author macchan
 * @version $Id: BehaviorEditPart.java,v 1.1 2003/12/11 10:26:51 macchan Exp $
 */
public class BehaviorEditPart extends EGraphicalEditPart {

	public static final Font FONT = new Font("Comic Sans MS", Font.BOLD, 14);

	private PanelVisualComponent panel = new PanelVisualComponent();
	private JLabel label = new JLabel();
	private VisualComponent statePanel = new RoundRectVisualComponent(15, 2);
	private JLabel stateLabel = new JLabel();

	/**
	 * Constructor for BehaviorEditPart.
	 */
	public BehaviorEditPart() {
		super();
	}

	/**
	 * @see jp.ac.keio.sfc.crew.view.sgef.editparts.SEditPart#activate()
	 */
	protected void activate() {
		super.activate();
		((CommunicationViewerRootEditPart) getRoot()).addBehaviorEditPart(this);
	}

	/**
	 * @see jp.ac.keio.sfc.crew.view.sgef.editparts.SEditPart#deactivate()
	 */
	protected void deactivate() {
		((CommunicationViewerRootEditPart) getRoot()).removeBehaviorEditPart(
			this);
		super.deactivate();
	}

	protected Behavior getBehavior() {
		return (Behavior) this.getModel();
	}

	/* (non-Javadoc)
	 * @see jp.ac.keio.sfc.crew.view.sgef.editparts.SEditPart#createVisual()
	 */
	protected VisualComponent createVisual() {
		label.setFont(FONT);
		panel.setLayout(new VerticalFlowLayout(VerticalFlowLayout.FILL));
		panel.add(label);
		panel.setBorder(BorderFactory.createLineBorder(Color.black, 2));
		panel.setBackground(new Color(230, 230, 230));
		panel.add(statePanel);
		statePanel.setLayout(new FlowLayout());
		statePanel.add(stateLabel);
		statePanel.setBackground(Color.WHITE);
		statePanel.setForeground(Color.BLACK);
		return panel;
	}

	protected List getModelUpperConnections() {
		return getBehavior().getAllChannels();
	}

	public void setStateVisible(boolean visible) {
		statePanel.setVisible(visible);
		refreshVisualRecursively();
	}

	public void refreshVisual() {
		label.setText(getBehaviorName());

		State state = getBehavior().getState();
		if (state != null) {
			//if (!(state instanceof TransitioningState)) {
			stateLabel.setText(state.getName());
			//}
		} else {
			stateLabel.setText("State is null");
		}

		statePanel.setSize(statePanel.getPreferredSize());
		panel.setSize(panel.getPreferredSize());

		getParent().refreshVisual();
	}

	private String getBehaviorName() {
		return CClassUtil.getSimpleClassName(getBehavior().getType().getName());
	}

}
