/*
 * BehaviorManagerEditPart.java
 * Created on 2003/10/13
 * 
 * Copyright (c) 2003 CreW Project. All rights reserved.
 */
package org.boxed_economy.components.commviewer.editparts;

import java.awt.Point;
import java.util.List;

import jp.ac.keio.sfc.crew.swing.visuals.VisualComponent;
import jp.ac.keio.sfc.crew.view.sgef.ext.editparts.EAttachmentEditPart;

import org.boxed_economy.components.commviewer.model.BehaviorManager;
import org
	.boxed_economy
	.components
	.commviewer
	.visuals
	.BehaviorManagerVisualComponent;

/**
 * Class BehaviorManagerEditPart.
 * 
 * @author macchan
 * @version $Id: BehaviorManagerEditPart.java,v 1.1 2003/12/11 10:26:51 macchan Exp $
 */
public class BehaviorManagerEditPart extends EAttachmentEditPart {

	/**
	 * Constructor for BehaviorManagerEditPart.
	 */
	public BehaviorManagerEditPart() {
		super();
	}

	/**
	 * @see jp.ac.keio.sfc.crew.view.sgef.ext.editparts.EAttachmentEditPart#getLayer()
	 */
	protected Object getLayer() {
		return CommunicationViewerRootEditPart.LAYER_BEHAVIOR_CONTAINERS;
	}

	protected BehaviorManager getBehaviorManager() {
		return (BehaviorManager) this.getModel();
	}

	protected List getModelChildren() {
		return getBehaviorManager().getAllBehaviors();
	}

	protected VisualComponent createVisual() {
		BehaviorManagerVisualComponent visual =
			new BehaviorManagerVisualComponent();
		return visual;
	}

	public void refreshVisual() {
		//Sets Size
		getContentPane().setSize(getContentPane().getPreferredSize());
		getVisual().setSize(getVisual().getPreferredSize());

		//Validate
		getVisual().validate();

		//Sets Location
		Point loc = getParent().getVisual().getLocation();
		getVisual().setLocation(loc.x - 10, loc.y + 40);
	}

	protected VisualComponent getContentPane() {
		return ((BehaviorManagerVisualComponent) getVisual()).getContentPane();
	}

}
