/*
 * RelationEditPart.java
 * Created on 2003/10/14
 * 
 * Copyright (c) 2003 CreW Project. All rights reserved.
 */
package org.boxed_economy.components.commviewer.editparts;

import java.awt.BasicStroke;
import java.awt.Color;

import jp.ac.keio.sfc.crew.swing.visuals.VisualComponent;
import jp.ac.keio.sfc.crew.view.sgef.ext.editparts.EConnectionEditPart;
import jp.ac.keio.sfc.crew.view.sgef.ext.visuals.ELineConnectionVisualComponent;

import org.boxed_economy.besp.model.fmfw.Channel;

/**
 * Class RelationEditPart.
 * 
 * @author macchan
 * @version $Id: ChannelEditPart.java,v 1.1 2003/12/11 10:26:51 macchan Exp $
 */
public class ChannelEditPart extends EConnectionEditPart {

	/**
	 * Constructor for RelationEditPart.
	 */
	public ChannelEditPart() {
		super();
	}

	protected Channel getChannel() {
		return (Channel) getModel();
	}

	public Object getModelSource() {
		return getChannel().getBehaviorA();
	}

	public Object getModelTarget() {
		return getChannel().getBehaviorB();
	}

	/* (non-Javadoc)
	 * @see jp.ac.keio.sfc.crew.view.sgef.editparts.SEditPart#createVisual()
	 */
	protected VisualComponent createVisual() {
		return createChannelVisual();
	}

	public static ELineConnectionVisualComponent createChannelVisual() {
		ELineConnectionVisualComponent c = new ELineConnectionVisualComponent();

		//Sets Color
		Color lineColor = new Color(150, 150, 150);
		c.setForeground(lineColor);

		//Sets Stroke
		float lineWidth = 6f;
		BasicStroke s = new BasicStroke(lineWidth);
		c.setStroke(s);

		//Sets multiple lines policy.
		c.setMultipleLineInterval(8);

		return c;
	}

}
