/*
 * CommViewerEditPartFactory.java
 * Created on 2003/10/18
 * 
 * Copyright (c) 2003 CreW Project. All rights reserved.
 */
package org.boxed_economy.components.commviewer.editparts;

import jp.ac.keio.sfc.crew.view.sgef.editparts.SEditPart;
import jp.ac.keio.sfc.crew.view.sgef.editparts.SPackageEditPartFactory;

import org.boxed_economy.besp.model.fmfw.Behavior;
import org.boxed_economy.besp.model.fmfw.World;

/**
 * Class CommViewerEditPartFactory.
 * 
 * @author macchan
 * @version $Id: CommViewerEditPartFactory.java,v 1.1 2003/12/11 10:26:51 macchan Exp $
 */
public class CommViewerEditPartFactory extends SPackageEditPartFactory {

	/**
	 * Constructor for CommViewerEditPartFactory.
	 */
	public CommViewerEditPartFactory(Package pack) {
		super(pack);
	}

	/**
	 * Constructor for CommViewerEditPartFactory.
	 */
	public CommViewerEditPartFactory(String packageName) {
		super(packageName);
	}

	/**
	 * @see jp.ac.keio.sfc.crew.view.sgef.editparts.SEditPartFactory#createEditPart(java.lang.Object)
	 */
	public SEditPart createEditPart(Object model) {
		if (model instanceof World) {
			return new WorldEditPart();
		} else if (model instanceof Behavior) {
			return new BehaviorEditPart();
		} else {
			return super.createEditPart(model);
		}
	}
}
