/*
 * CommunicationViewerRootEditPart.java
 * Created on 2003/10/25
 * 
 * Copyright (c) 2003 CreW Project. All rights reserved.
 */
package org.boxed_economy.components.commviewer.editparts;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;

import jp.ac.keio.sfc.crew.swing.visuals.LayerVisualComponent;
import jp.ac.keio.sfc.crew.view.sgef.ext.editparts.EGraphicalRootEditPart;

/**
 * Class CommunicationViewerRootEditPart.
 * 
 * @author macchan
 * @version $Id: CommunicationViewerRootEditPart.java,v 1.1 2003/12/11 10:26:51 macchan Exp $
 */
public class CommunicationViewerRootEditPart extends EGraphicalRootEditPart {

	/*****************************************
	 * Constants.
	 *****************************************/

	public static final Object LAYER_AGENT_LABELS = "AGENT_LABELS";
	public static final Object LAYER_RELATION_LABELS = "RELATION_LABELS";
	public static final Object LAYER_BEHAVIOR_CONTAINERS =
		"BEHAVIOR_CONTAINERS";

	/*****************************************
	 * Instance Variables.
	 *****************************************/

	private Set behaviorEditParts = new LinkedHashSet();
	private boolean behaviorVisible = true;

	/*****************************************
	 * Constants.
	 *****************************************/

	protected void installLayers() {
		super.installLayers();
		installLayer(
			LAYER_BEHAVIOR_CONTAINERS,
			LAYER_ATTACHMENTS,
			new LayerVisualComponent(),
			0);
		installLayer(
			LAYER_RELATION_LABELS,
			LAYER_ATTACHMENTS,
			new LayerVisualComponent(),
			0);
		installLayer(
			LAYER_AGENT_LABELS,
			LAYER_ATTACHMENTS,
			new LayerVisualComponent(),
			0);
	}

	/*****************************************
	 * behaviorEditParts management.
	 *****************************************/

	public void setAllBehaviorStateVisible(boolean visible) {
		this.behaviorVisible = visible;
		for (Iterator i = behaviorEditParts.iterator(); i.hasNext();) {
			BehaviorEditPart editpart = (BehaviorEditPart) i.next();
			editpart.setStateVisible(visible);
		}
	}

	public boolean isBehaviorStateVisible() {
		return behaviorVisible;
	}

	public void addBehaviorEditPart(BehaviorEditPart editpart) {
		behaviorEditParts.add(editpart);
	}

	public void removeBehaviorEditPart(BehaviorEditPart editpart) {
		behaviorEditParts.remove(editpart);
	}

}
